/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class PostDownloadHandler
implements Runnable {
    private final DownloadTask task;
    private final Future<?> future;
    private Consumer<Collection<Object>> errorReporter;
    private static final Set<String> NO_DATA_ERROR_MESSAGES = new HashSet<String>();

    public PostDownloadHandler(DownloadTask task, Future<?> future) {
        this.task = task;
        this.future = future;
    }

    public PostDownloadHandler(DownloadTask task, Future<?> future, Consumer<Collection<Object>> errorReporter) {
        this(task, future);
        this.errorReporter = errorReporter;
    }

    public static boolean addNoDataErrorMessage(String message) {
        return NO_DATA_ERROR_MESSAGES.add(message);
    }

    public static boolean isNoDataErrorMessage(Object message) {
        return NO_DATA_ERROR_MESSAGES.contains(message);
    }

    @Override
    public void run() {
        try {
            this.future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            Logging.error(e);
            return;
        }
        LinkedHashSet<Object> errors = new LinkedHashSet<Object>(this.task.getErrorObjects());
        if (this.errorReporter != null) {
            GuiHelper.runInEDT(() -> this.errorReporter.accept(errors));
        }
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            Object error = errors.iterator().next();
            if (!GraphicsEnvironment.isHeadless()) {
                SwingUtilities.invokeLater(() -> {
                    if (error instanceof Exception) {
                        ExceptionDialogUtil.explainException((Exception)error);
                    } else if (PostDownloadHandler.isNoDataErrorMessage(error)) {
                        new Notification(error.toString()).setIcon(2).show();
                    } else {
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), error.toString(), I18n.tr("Error during download", new Object[0]), 0);
                    }
                });
            }
            return;
        }
        List<String> items = this.task.getErrorMessages();
        if (!items.isEmpty() && !GraphicsEnvironment.isHeadless()) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), "<html>" + Utils.joinAsHtmlUnorderedList(items) + "</html>", I18n.tr("Errors during download", new Object[0]), 0));
        }
    }
}

