/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jsampler.CC;
import org.jsampler.event.SamplerAdapter;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.event.SamplerEvent;
import org.jsampler.view.classic.ClassicI18n;

public class Statusbar
extends JPanel {
    JLabel l1;
    JLabel l2;
    private final JProgressBar pbTotalVoices = new JProgressBar();
    private final Handler handler = new Handler();

    public Statusbar() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.l1 = new JLabel();
        this.l1.setFont(this.l1.getFont().deriveFont(0));
        this.l1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.l2 = new JLabel(" ");
        this.l2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.l2.setPreferredSize(this.l1.getPreferredSize());
        this.setTotalChannelCount(CC.getSamplerModel().getChannelCount());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.pbTotalVoices, "Center");
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pbTotalVoices.setBorderPainted(false);
        this.pbTotalVoices.setStringPainted(true);
        float f = this.pbTotalVoices.getFont().getSize2D();
        f = f > 10.0f ? f - 3.0f : 8.0f;
        this.pbTotalVoices.setFont(this.pbTotalVoices.getFont().deriveFont(f));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.l1, gridBagConstraints);
        this.add(this.l1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.3;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagLayout.setConstraints(this.l2, gridBagConstraints);
        this.add(this.l2);
        this.getHandler().totalVoiceCountChanged(null);
        CC.getSamplerModel().addSamplerListener(this.getHandler());
        CC.getSamplerModel().addSamplerChannelListListener(this.getHandler());
    }

    private void setTotalChannelCount(int n) {
        if (n == 1) {
            this.l1.setText(" " + ClassicI18n.i18n.getLabel("Statusbar.totalChannel", n));
        } else {
            this.l1.setText(" " + ClassicI18n.i18n.getLabel("Statusbar.totalChannels", n));
        }
        this.l2.setPreferredSize(this.l1.getPreferredSize());
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    extends SamplerAdapter
    implements SamplerChannelListListener {
        private Handler() {
        }

        @Override
        public void totalVoiceCountChanged(SamplerEvent samplerEvent) {
            int n = CC.getSamplerModel().getTotalVoiceCount();
            int n2 = CC.getSamplerModel().getTotalVoiceCountMax();
            if (n2 == 0) {
                n2 = 1;
            }
            Statusbar.this.pbTotalVoices.setMaximum(n2);
            Statusbar.this.pbTotalVoices.setValue(n);
            Statusbar.this.pbTotalVoices.setString(ClassicI18n.i18n.getLabel("Statusbar.pbTotalVoices", n));
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
            Statusbar.this.setTotalChannelCount(CC.getSamplerModel().getChannelCount());
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            Statusbar.this.setTotalChannelCount(CC.getSamplerModel().getChannelCount());
        }
    }
}

