/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.ECDSAAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;

public class ECDSASignatureSignerContext
extends AsymmetricSignatureSignerContext {
    public ECDSASignatureSignerContext(KeyWrapper key) throws SignatureException {
        super(key);
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        try {
            int size = ECDSAAlgorithm.getSignatureLength(this.getAlgorithm());
            return ECDSAAlgorithm.asn1derToConcatenatedRS(super.sign(data), size);
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", e);
        }
    }
}

