/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MembershipType {
    DN{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup) {
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            return this.getLDAPMembersWithParent(groupMapper.getLdapProvider(), ldapGroup, config.getMembershipLdapAttribute(), LDAPDn.fromString(config.getLDAPGroupsDn()), config.getLDAPGroupNameLdapAttribute());
        }

        protected Set<LDAPDn> getLDAPMembersWithParent(LDAPStorageProvider ldapProvider, LDAPObject ldapGroup, String membershipLdapAttribute, LDAPDn requiredParentDn, String rdnAttr) {
            Set<String> allMemberships = LDAPUtils.getExistingMemberships(ldapProvider, membershipLdapAttribute, ldapGroup);
            LinkedHashSet<LDAPDn> result = new LinkedHashSet<LDAPDn>();
            for (String membership : allMemberships) {
                LDAPDn childDn = LDAPDn.fromString(membership);
                if (!childDn.isDescendantOf(requiredParentDn) || childDn.getFirstRdn().getAttrValue(rdnAttr) == null) continue;
                result.add(childDn);
            }
            return result;
        }

        @Override
        public List<UserModel> getGroupMembers(RealmModel realm, CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            LDAPStorageProvider ldapProvider = groupMapper.getLdapProvider();
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
            LDAPDn usersDn = LDAPDn.fromString(ldapProvider.getLdapIdentityStore().getConfig().getUsersDn());
            Set<LDAPDn> userDns = this.getLDAPMembersWithParent(ldapProvider, ldapGroup, config.getMembershipLdapAttribute(), usersDn, ldapConfig.getRdnLdapAttribute());
            if (userDns == null || userDns.size() <= firstResult) {
                return Collections.emptyList();
            }
            return ldapProvider.loadUsersByDNs(realm, userDns, firstResult, maxResults).collect(Collectors.toList());
        }
    }
    ,
    UID{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup) {
            return Collections.emptySet();
        }

        @Override
        public List<UserModel> getGroupMembers(RealmModel realm, CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            LDAPStorageProvider ldapProvider = groupMapper.getLdapProvider();
            LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
            String memberAttrName = groupMapper.getConfig().getMembershipLdapAttribute();
            Set<String> memberUids = LDAPUtils.getExistingMemberships(ldapProvider, memberAttrName, ldapGroup);
            if (memberUids == null || memberUids.size() <= firstResult) {
                return Collections.emptyList();
            }
            String membershipUserAttrName = groupMapper.getConfig().getMembershipUserLdapAttribute(ldapConfig);
            return ldapProvider.loadUsersByUniqueAttribute(realm, membershipUserAttrName, memberUids, firstResult, maxResults).collect(Collectors.toList());
        }
    };


    public abstract Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper var1, LDAPObject var2);

    public abstract List<UserModel> getGroupMembers(RealmModel var1, CommonLDAPGroupMapper var2, LDAPObject var3, int var4, int var5);
}

