/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;

public class ExtractionContextImpl
implements ExtractionContext {
    private final ServiceRegistry serviceRegistry;
    private final JdbcEnvironment jdbcEnvironment;
    private final SqlStringGenerationContext context;
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final ExtractionContext.DatabaseObjectAccess registeredTableAccess;
    private Connection jdbcConnection;
    private DatabaseMetaData jdbcDatabaseMetaData;

    public ExtractionContextImpl(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, SqlStringGenerationContext context, JdbcConnectionAccess jdbcConnectionAccess, ExtractionContext.DatabaseObjectAccess registeredTableAccess) {
        this.serviceRegistry = serviceRegistry;
        this.jdbcEnvironment = jdbcEnvironment;
        this.context = context;
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.registeredTableAccess = registeredTableAccess;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    @Override
    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return this.context;
    }

    @Override
    public Connection getJdbcConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw this.jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC Connection");
            }
        }
        return this.jdbcConnection;
    }

    @Override
    public DatabaseMetaData getJdbcDatabaseMetaData() {
        if (this.jdbcDatabaseMetaData == null) {
            try {
                this.jdbcDatabaseMetaData = this.getJdbcConnection().getMetaData();
            }
            catch (SQLException e) {
                throw this.jdbcEnvironment.getSqlExceptionHelper().convert(e, "Unable to obtain JDBC DatabaseMetaData");
            }
        }
        return this.jdbcDatabaseMetaData;
    }

    @Override
    public Identifier getDefaultCatalog() {
        return this.context.getDefaultCatalog();
    }

    @Override
    public Identifier getDefaultSchema() {
        return this.context.getDefaultSchema();
    }

    @Override
    public ExtractionContext.DatabaseObjectAccess getDatabaseObjectAccess() {
        return this.registeredTableAccess;
    }

    @Override
    public void cleanup() {
        if (this.jdbcDatabaseMetaData != null) {
            this.jdbcDatabaseMetaData = null;
        }
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnectionAccess.releaseConnection(this.jdbcConnection);
            }
            catch (SQLException exception) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.unableToReleaseConnection(exception);
            }
        }
    }
}

