/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type[] substTypeArgs;
    private final Type rawType;
    private final Type ownerType;

    public ParameterizedTypeImpl(Type rawType, Type[] substTypeArgs, Type ownerType) {
        this.substTypeArgs = substTypeArgs;
        this.rawType = rawType;
        this.ownerType = ownerType;
    }

    public static ParameterizedTypeImpl from(ParameterizedTypeDetails typeDetails) {
        Class attributeType = typeDetails.determineRawClass().toJavaClass();
        List arguments = typeDetails.asParameterizedType().getArguments();
        int argumentsSize = arguments.size();
        Type[] argumentTypes = new Type[argumentsSize];
        for (int i = 0; i < argumentsSize; ++i) {
            TypeDetails argument = (TypeDetails)arguments.get(i);
            argumentTypes[i] = argument.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE ? ParameterizedTypeImpl.from(argument.asParameterizedType()) : argument.determineRawClass().toJavaClass();
        }
        TypeVariableScope owner = typeDetails.asParameterizedType().getOwner();
        Class ownerType = owner != null ? owner.determineRawClass().toJavaClass() : null;
        return new ParameterizedTypeImpl(attributeType, argumentTypes, ownerType);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.substTypeArgs;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return Objects.equals(this.getOwnerType(), other.getOwnerType()) && Objects.equals(this.getRawType(), other.getRawType()) && Arrays.equals(this.getActualTypeArguments(), other.getActualTypeArguments());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getActualTypeArguments()) ^ Objects.hashCode(this.getOwnerType()) ^ Objects.hashCode(this.getRawType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getTypeName());
            sb.append("$");
            Type type = this.ownerType;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                sb.append(this.rawType.getTypeName().replace(parameterizedType.getRawType().getTypeName() + "$", ""));
            } else {
                type = this.rawType;
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    sb.append(clazz.getSimpleName());
                } else {
                    sb.append(this.rawType.getTypeName());
                }
            }
        } else {
            sb.append(this.rawType.getTypeName());
        }
        if (this.substTypeArgs != null) {
            StringJoiner sj = new StringJoiner(", ", "<", ">");
            sj.setEmptyValue("");
            for (Type t : this.substTypeArgs) {
                sj.add(t.getTypeName());
            }
            sb.append(sj);
        }
        return sb.toString();
    }
}

