/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.Response;
import java.security.PublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.authentication.authenticators.client.JWTClientValidator;
import org.keycloak.crypto.ClientSignatureVerifierProvider;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.TokenManager;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ServicesLogger;

public class JWTClientAuthenticator
extends AbstractClientAuthenticator {
    public static final String PROVIDER_ID = "client-jwt";
    public static final String ATTR_PREFIX = "jwt.credential";
    public static final String CERTIFICATE_ATTR = "jwt.credential.certificate";

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        try {
            JWTClientValidator validator = new JWTClientValidator(context, this::verifySignature, this.getId());
            if (!validator.validate()) {
                return;
            }
            context.success();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.errorValidatingAssertion(e);
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Client authentication with signed JWT failed: " + e.getMessage());
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
        }
    }

    public boolean verifySignature(AbstractJWTClientValidator validator) {
        boolean signatureValid;
        ClientAuthenticationFlowContext context = validator.getContext();
        ClientModel client = validator.getClient();
        PublicKey clientPublicKey = this.getSignatureValidationKey(client, context, validator.getJws());
        if (clientPublicKey == null) {
            return false;
        }
        try {
            JsonWebToken jwt = (JsonWebToken)context.getSession().tokens().decodeClientJWT(validator.getClientAssertion(), client, (jose, validatedClient) -> {
                TokenManager.DEFAULT_VALIDATOR.accept(jose, validatedClient);
                String signatureAlgorithm = jose.getHeader().getRawAlgorithm();
                ClientSignatureVerifierProvider signatureProvider = (ClientSignatureVerifierProvider)context.getSession().getProvider(ClientSignatureVerifierProvider.class, signatureAlgorithm);
                if (signatureProvider == null) {
                    throw new RuntimeException("Algorithm not supported");
                }
                if (!signatureProvider.isAsymmetricAlgorithm()) {
                    throw new RuntimeException("Algorithm is not asymmetric");
                }
            }, JsonWebToken.class);
            signatureValid = jwt != null;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new RuntimeException("Signature on JWT token failed validation", cause);
        }
        if (!signatureValid) {
            throw new RuntimeException("Signature on JWT token failed validation");
        }
        return true;
    }

    protected PublicKey getSignatureValidationKey(ClientModel client, ClientAuthenticationFlowContext context, JWSInput jws) {
        PublicKey publicKey = PublicKeyStorageManager.getClientPublicKey(context.getSession(), client, jws);
        if (publicKey == null) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Unable to load public key");
            context.failure(AuthenticationFlowError.CLIENT_CREDENTIALS_SETUP_REQUIRED, challengeResponse);
            return null;
        }
        return publicKey;
    }

    public String getDisplayType() {
        return "Signed Jwt";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Validates client based on signed JWT issued by client and signed with the Client private key";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new LinkedList<ProviderConfigProperty>();
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("client-keystore-file", "REPLACE WITH THE LOCATION OF YOUR KEYSTORE FILE");
        props.put("client-keystore-type", "jks");
        props.put("client-keystore-password", "REPLACE WITH THE KEYSTORE PASSWORD");
        props.put("client-key-password", "REPLACE WITH THE KEY PASSWORD IN KEYSTORE");
        props.put("client-key-alias", client.getClientId());
        props.put("token-timeout", 10);
        String algorithm = client.getAttribute("token.endpoint.auth.signing.alg");
        if (algorithm != null) {
            props.put("algorithm", algorithm);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("jwt", props);
        return config;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        if (loginProtocol.equals("openid-connect")) {
            HashSet<String> results = new HashSet<String>();
            results.add("private_key_jwt");
            return results;
        }
        return Collections.emptySet();
    }
}

