/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class RegistrationUsernameExistsValidator
implements SimpleValidator {
    public static final String ID = "up-registration-username-exists";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        KeycloakSession session = context.getSession();
        RealmModel realm = session.getContext().getRealm();
        if (realm.isRegistrationEmailAsUsername()) {
            return context;
        }
        List values = (List)input;
        if (values == null || values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        UserModel existing = session.users().getUserByUsername(realm, value);
        if (existing != null) {
            context.addError(new ValidationError(ID, inputHint, "usernameExistsMessage").setStatusCode(Response.Status.CONFLICT));
        }
        return context;
    }
}

