/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.extras.reflect;

import io.github.dmlloyd.classfile.extras.reflect.ClassFileFormatVersion;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public enum AccessFlag {
    PUBLIC(1, true, Location.SET_PUBLIC_1, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv == ClassFileFormatVersion.RELEASE_0 ? Location.SET_CLASS_FIELD_METHOD : Location.SET_PUBLIC_1;
        }
    }),
    PRIVATE(2, true, Location.SET_FIELD_METHOD_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv == ClassFileFormatVersion.RELEASE_0 ? Location.SET_FIELD_METHOD : Location.SET_FIELD_METHOD_INNER_CLASS;
        }
    }),
    PROTECTED(4, true, Location.SET_FIELD_METHOD_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv == ClassFileFormatVersion.RELEASE_0 ? Location.SET_FIELD_METHOD : Location.SET_FIELD_METHOD_INNER_CLASS;
        }
    }),
    STATIC(8, true, Location.SET_FIELD_METHOD_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv == ClassFileFormatVersion.RELEASE_0 ? Location.SET_FIELD_METHOD : Location.SET_FIELD_METHOD_INNER_CLASS;
        }
    }),
    FINAL(16, true, Location.SET_FINAL_8, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            if (cffv.compareTo(ClassFileFormatVersion.RELEASE_8) >= 0) {
                return Location.SET_FINAL_8;
            }
            return cffv == ClassFileFormatVersion.RELEASE_0 ? Location.SET_CLASS_FIELD_METHOD : Location.SET_CLASS_FIELD_METHOD_INNER_CLASS;
        }
    }),
    SUPER(32, false, Location.SET_CLASS, null),
    OPEN(32, false, Location.SET_MODULE, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0 ? Location.SET_MODULE : Location.EMPTY_SET;
        }
    }),
    TRANSITIVE(32, false, Location.SET_MODULE_REQUIRES, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0 ? Location.SET_MODULE_REQUIRES : Location.EMPTY_SET;
        }
    }),
    SYNCHRONIZED(32, true, Location.SET_METHOD, null),
    STATIC_PHASE(64, false, Location.SET_MODULE_REQUIRES, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0 ? Location.SET_MODULE_REQUIRES : Location.EMPTY_SET;
        }
    }),
    VOLATILE(64, true, Location.SET_FIELD, null),
    BRIDGE(64, false, Location.SET_METHOD, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_5) >= 0 ? Location.SET_METHOD : Location.EMPTY_SET;
        }
    }),
    TRANSIENT(128, true, Location.SET_FIELD, null),
    VARARGS(128, false, Location.SET_METHOD, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_5) >= 0 ? Location.SET_METHOD : Location.EMPTY_SET;
        }
    }),
    NATIVE(256, true, Location.SET_METHOD, null),
    INTERFACE(512, false, Location.SET_CLASS_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_0) == 0 ? Location.SET_CLASS : Location.SET_CLASS_INNER_CLASS;
        }
    }),
    ABSTRACT(1024, true, Location.SET_CLASS_METHOD_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_0) == 0 ? Location.SET_CLASS_METHOD : Location.SET_CLASS_METHOD_INNER_CLASS;
        }
    }),
    STRICT(2048, true, Location.EMPTY_SET, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_2) >= 0 && cffv.compareTo(ClassFileFormatVersion.RELEASE_16) <= 0 ? Location.SET_METHOD : Location.EMPTY_SET;
        }
    }),
    SYNTHETIC(4096, false, Location.SET_SYNTHETIC_9, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            if (cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0) {
                return Location.SET_SYNTHETIC_9;
            }
            return switch (cffv) {
                case ClassFileFormatVersion.RELEASE_7 -> Location.SET_SYNTHETIC_7;
                case ClassFileFormatVersion.RELEASE_8 -> Location.SET_SYNTHETIC_8;
                default -> Location.EMPTY_SET;
            };
        }
    }),
    ANNOTATION(8192, false, Location.SET_CLASS_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_5) >= 0 ? Location.SET_CLASS_INNER_CLASS : Location.EMPTY_SET;
        }
    }),
    ENUM(16384, false, Location.SET_CLASS_FIELD_INNER_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_5) >= 0 ? Location.SET_CLASS_FIELD_INNER_CLASS : Location.EMPTY_SET;
        }
    }),
    MANDATED(32768, false, Location.SET_MANDATED_9, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            if (cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0) {
                return Location.SET_MANDATED_9;
            }
            return cffv == ClassFileFormatVersion.RELEASE_8 ? Location.SET_METHOD_PARAM : Location.EMPTY_SET;
        }
    }),
    MODULE(32768, false, Location.SET_CLASS, new Function<ClassFileFormatVersion, Set<Location>>(){

        @Override
        public Set<Location> apply(ClassFileFormatVersion cffv) {
            return cffv.compareTo(ClassFileFormatVersion.RELEASE_9) >= 0 ? Location.SET_CLASS : Location.EMPTY_SET;
        }
    });

    private final int mask;
    private final boolean sourceModifier;
    private final Set<Location> locations;
    private final Function<ClassFileFormatVersion, Set<Location>> cffvToLocations;

    private AccessFlag(int mask, boolean sourceModifier, Set<Location> locations, Function<ClassFileFormatVersion, Set<Location>> cffvToLocations) {
        this.mask = mask;
        this.sourceModifier = sourceModifier;
        this.locations = locations;
        this.cffvToLocations = cffvToLocations;
    }

    public int mask() {
        return this.mask;
    }

    public boolean sourceModifier() {
        return this.sourceModifier;
    }

    public Set<Location> locations() {
        return this.locations;
    }

    public Set<Location> locations(ClassFileFormatVersion cffv) {
        Objects.requireNonNull(cffv);
        if (this.cffvToLocations == null) {
            return this.locations;
        }
        return this.cffvToLocations.apply(cffv);
    }

    public static Set<AccessFlag> maskToAccessFlags(int mask, Location location) {
        EnumSet<AccessFlag> result = EnumSet.noneOf(AccessFlag.class);
        for (AccessFlag accessFlag : LocationToFlags.locationToFlags.get((Object)location)) {
            int accessMask = accessFlag.mask();
            if ((mask & accessMask) == 0) continue;
            result.add(accessFlag);
            mask &= ~accessMask;
        }
        if (mask != 0) {
            throw new IllegalArgumentException("Unmatched bit position 0x" + Integer.toHexString(mask) + " for location " + location);
        }
        return Collections.unmodifiableSet(result);
    }

    private static class LocationToFlags {
        private static final Map<Location, Set<AccessFlag>> locationToFlags = Map.ofEntries(Map.entry(Location.CLASS, Set.of(PUBLIC, FINAL, SUPER, INTERFACE, ABSTRACT, SYNTHETIC, ANNOTATION, ENUM, MODULE)), Map.entry(Location.FIELD, Set.of(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, VOLATILE, TRANSIENT, SYNTHETIC, ENUM)), Map.entry(Location.METHOD, Set.of(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, SYNCHRONIZED, BRIDGE, VARARGS, NATIVE, ABSTRACT, STRICT, SYNTHETIC)), Map.entry(Location.INNER_CLASS, Set.of(PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, INTERFACE, ABSTRACT, SYNTHETIC, ANNOTATION, ENUM)), Map.entry(Location.METHOD_PARAMETER, Set.of(FINAL, SYNTHETIC, MANDATED)), Map.entry(Location.MODULE, Set.of(OPEN, SYNTHETIC, MANDATED)), Map.entry(Location.MODULE_REQUIRES, Set.of(TRANSITIVE, STATIC_PHASE, SYNTHETIC, MANDATED)), Map.entry(Location.MODULE_EXPORTS, Set.of(SYNTHETIC, MANDATED)), Map.entry(Location.MODULE_OPENS, Set.of(SYNTHETIC, MANDATED)));

        private LocationToFlags() {
        }
    }

    public static enum Location {
        CLASS,
        FIELD,
        METHOD,
        INNER_CLASS,
        METHOD_PARAMETER,
        MODULE,
        MODULE_REQUIRES,
        MODULE_EXPORTS,
        MODULE_OPENS;

        private static final Set<Location> EMPTY_SET;
        private static final Set<Location> SET_MODULE;
        private static final Set<Location> SET_CLASS_METHOD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_FIELD_METHOD;
        private static final Set<Location> SET_CLASS_FIELD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_FIELD_METHOD_INNER_CLASS;
        private static final Set<Location> SET_CLASS_METHOD;
        private static final Set<Location> SET_FIELD_METHOD;
        private static final Set<Location> SET_FIELD_METHOD_INNER_CLASS;
        private static final Set<Location> SET_METHOD;
        private static final Set<Location> SET_METHOD_PARAM;
        private static final Set<Location> SET_FIELD;
        private static final Set<Location> SET_CLASS;
        private static final Set<Location> SET_CLASS_INNER_CLASS;
        private static final Set<Location> SET_MODULE_REQUIRES;
        private static final Set<Location> SET_PUBLIC_1;
        private static final Set<Location> SET_FINAL_8;
        private static final Set<Location> SET_SYNTHETIC_7;
        private static final Set<Location> SET_SYNTHETIC_8;
        private static final Set<Location> SET_SYNTHETIC_9;
        private static final Set<Location> SET_MANDATED_9;

        static {
            EMPTY_SET = Set.of();
            SET_MODULE = Set.of(MODULE);
            SET_CLASS_METHOD_INNER_CLASS = Set.of(CLASS, METHOD, INNER_CLASS);
            SET_CLASS_FIELD_METHOD = Set.of(CLASS, FIELD, METHOD);
            SET_CLASS_FIELD_INNER_CLASS = Set.of(CLASS, FIELD, INNER_CLASS);
            SET_CLASS_FIELD_METHOD_INNER_CLASS = Set.of(CLASS, FIELD, METHOD, INNER_CLASS);
            SET_CLASS_METHOD = Set.of(CLASS, METHOD);
            SET_FIELD_METHOD = Set.of(FIELD, METHOD);
            SET_FIELD_METHOD_INNER_CLASS = Set.of(FIELD, METHOD, INNER_CLASS);
            SET_METHOD = Set.of(METHOD);
            SET_METHOD_PARAM = Set.of(METHOD_PARAMETER);
            SET_FIELD = Set.of(FIELD);
            SET_CLASS = Set.of(CLASS);
            SET_CLASS_INNER_CLASS = Set.of(CLASS, INNER_CLASS);
            SET_MODULE_REQUIRES = Set.of(MODULE_REQUIRES);
            SET_PUBLIC_1 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS);
            SET_FINAL_8 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER);
            SET_SYNTHETIC_7 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS);
            SET_SYNTHETIC_8 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER);
            SET_SYNTHETIC_9 = Set.of(CLASS, FIELD, METHOD, INNER_CLASS, METHOD_PARAMETER, MODULE, MODULE_REQUIRES, MODULE_EXPORTS, MODULE_OPENS);
            SET_MANDATED_9 = Set.of(METHOD_PARAMETER, MODULE, MODULE_REQUIRES, MODULE_EXPORTS, MODULE_OPENS);
        }
    }
}

