/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.DownloadInfos;
import mediathek.daten.DownloadStartInfo;
import mediathek.daten.ListeDownloads;
import mediathek.gui.messages.DownloadInfoUpdateAvailableEvent;
import mediathek.tool.FileSize;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;

public class DownloadInformationLabel
extends JLabel {
    public DownloadInformationLabel() {
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    @Handler
    private void handleDownloadInfoUpdate(DownloadInfoUpdateAvailableEvent e) {
        SwingUtilities.invokeLater(this::setInfoFilme);
    }

    private void setInfoFilme() {
        this.setText(this.getInfoTextDownloads());
    }

    private String getInfoTextDownloads() {
        Object textLinks;
        Daten daten = Daten.getInstance();
        ListeDownloads listeDownloads = daten.getListeDownloads();
        DownloadStartInfo info = listeDownloads.getStarts();
        Object object = textLinks = info.total_num_download_list_entries == 1 ? "1 Download" : info.total_num_download_list_entries + " Downloads";
        if (info.hasValues()) {
            textLinks = (String)textLinks + ": ";
            textLinks = (String)textLinks + (String)(info.running == 1 ? "1 l\u00e4uft" : info.running + " laufen");
            if (info.running > 0) {
                textLinks = (String)textLinks + " (" + daten.getDownloadInfos().getBandwidthStr() + ")";
                DownloadInfos infos = daten.getDownloadInfos();
                long byteAlleDownloads = infos.getByteAlleDownloads();
                long byteAktDownloads = infos.getByteAktDownloads();
                if (byteAlleDownloads > 0L || byteAktDownloads > 0L) {
                    textLinks = (String)textLinks + " (";
                    textLinks = (String)textLinks + "Gr\u00f6\u00dfe: ";
                    textLinks = byteAktDownloads > 0L ? (String)textLinks + FileSize.convertSize(byteAktDownloads) + " von " + FileSize.convertSize(byteAlleDownloads) + " MByte)" : (String)textLinks + FileSize.convertSize(byteAlleDownloads) + " MByte)";
                }
            }
            textLinks = (String)textLinks + (String)(info.initialized == 1 ? ", 1 wartet" : ", " + info.initialized + " warten");
            if (info.finished > 0) {
                textLinks = (String)textLinks + (String)(info.finished == 1 ? ", 1 fertig" : ", " + info.finished + " fertig");
            }
            if (info.error > 0) {
                textLinks = (String)textLinks + (String)(info.error == 1 ? ", 1 fehlerhaft" : ", " + info.error + " fehlerhaft");
            }
        }
        return textLinks;
    }
}

