# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Moodle::Helpers
  # Helper methods are private and should not be called by modules

  private

  # Returns the POST data for a Moodle login request
  #
  # @param user [String] Username
  # @param pass [String] Password
  # @param token [String] login token
  # @return [Hash] The post data for vars_post Parameter
  def moodle_helper_login_post_data(user, pass, token)
    post_data = {
      'username' => user.to_s,
      'password' => pass.to_s,
      'logintoken' => token.to_s,
      'anchor' => ''
    }
    post_data
  end

  # Returns the GET data for a Moodle loginas request
  #
  # @param course_id [String] ID of the course the user is registered in
  # @param user_id [String] User ID of the user to impersonate
  # @param session_key [String] session key for the current session
  # @return [Hash] The get data for vars_get Parameter
  def moodle_helper_loginas_get_data(course_id, user_id, session_key)
    get_data = {
      'id' => course_id,
      'user' => user_id,
      'sesskey' => session_key
    }
    get_data
  end

  # Returns the GET data for a Moodle Course Enrollment request
  #
  # @param user_id [String] ID of the user to enrol
  # @param course_id [String] ID of the course to enrol in
  # @param enrol_id [String] ID of the enrolment
  # @param sess_key [String] session key
  # @param role [String] Optional value of the role.  1 is default and manager, 5 is student
  # @return [Hash] The get data for vars_get Parameter
  def moodle_helper_enrol_get_data(user_id, course_id, enrol_id, sess_key, role = '1')
    get_data = {
      'mform_showmore_main' => '0',
      'id' => course_id,
      'action' => 'enrol',
      'enrolid' => enrol_id,
      'sesskey' => sess_key,
      '_qf__enrol_manual_enrol_users_form' => '1',
      'mform_showmore_id_main' => '0',
      'userlist[]' => user_id,
      'roletoassign' => role,
      'startdate' => '4',
      'duration' => ''
    }
    get_data
  end
end
