/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.snapshots.SnapshotInfo;

@PublicApi(since="1.0.0")
public class CreateSnapshotResponse
extends ActionResponse
implements ToXContentObject {
    private static final ObjectParser<CreateSnapshotResponse, Void> PARSER = new ObjectParser(CreateSnapshotResponse.class.getName(), true, CreateSnapshotResponse::new);
    @Nullable
    private SnapshotInfo snapshotInfo;

    CreateSnapshotResponse() {
    }

    public CreateSnapshotResponse(@Nullable SnapshotInfo snapshotInfo) {
        this.snapshotInfo = snapshotInfo;
    }

    public CreateSnapshotResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshotInfo = (SnapshotInfo)in.readOptionalWriteable(SnapshotInfo::new);
    }

    private void setSnapshotInfoFromBuilder(SnapshotInfo.SnapshotInfoBuilder snapshotInfoBuilder) {
        this.snapshotInfo = snapshotInfoBuilder.build();
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.snapshotInfo;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.snapshotInfo);
    }

    public RestStatus status() {
        if (this.snapshotInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.snapshotInfo.status();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.snapshotInfo != null) {
            builder.field("snapshot");
            this.snapshotInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        builder.endObject();
        return builder;
    }

    public static CreateSnapshotResponse fromXContent(XContentParser parser) {
        return (CreateSnapshotResponse)((Object)PARSER.apply(parser, null));
    }

    public String toString() {
        return "CreateSnapshotResponse{snapshotInfo=" + String.valueOf(this.snapshotInfo) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateSnapshotResponse that = (CreateSnapshotResponse)((Object)o);
        return Objects.equals(this.snapshotInfo, that.snapshotInfo);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotInfo);
    }

    static {
        PARSER.declareObject(CreateSnapshotResponse::setSnapshotInfoFromBuilder, SnapshotInfo.SNAPSHOT_INFO_PARSER, new ParseField("snapshot", new String[0]));
    }
}

