/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class SnapshotsStatusResponse
extends ActionResponse
implements ToXContentObject {
    private final List<SnapshotStatus> snapshots;
    private static final ConstructingObjectParser<SnapshotsStatusResponse, Void> PARSER = new ConstructingObjectParser("snapshots_status_response", true, parsedObjects -> {
        List snapshots = (List)parsedObjects[0];
        return new SnapshotsStatusResponse(snapshots);
    });

    public SnapshotsStatusResponse(StreamInput in) throws IOException {
        super(in);
        this.snapshots = Collections.unmodifiableList(in.readList(SnapshotStatus::new));
    }

    SnapshotsStatusResponse(List<SnapshotStatus> snapshots) {
        this.snapshots = snapshots;
    }

    public List<SnapshotStatus> getSnapshots() {
        return this.snapshots;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.snapshots);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotStatus snapshot : this.snapshots) {
            snapshot.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static SnapshotsStatusResponse fromXContent(XContentParser parser) throws IOException {
        return (SnapshotsStatusResponse)((Object)PARSER.parse(parser, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.snapshots, ((SnapshotsStatusResponse)((Object)o)).snapshots);
    }

    public int hashCode() {
        return this.snapshots != null ? this.snapshots.hashCode() : 0;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), SnapshotStatus.PARSER, new ParseField("snapshots", new String[0]));
    }
}

