/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opensearch.common.ExponentiallyWeightedMovingAverage;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.util.concurrent.EWMATrackingThreadPoolExecutor;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ResizableBlockingQueue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.concurrent.TimedRunnable;
import org.opensearch.common.util.concurrent.WrappedRunnable;
import org.opensearch.common.util.concurrent.XRejectedExecutionHandler;

public final class QueueResizableOpenSearchThreadPoolExecutor
extends OpenSearchThreadPoolExecutor
implements EWMATrackingThreadPoolExecutor {
    private final ResizableBlockingQueue<Runnable> workQueue;
    private final Function<Runnable, WrappedRunnable> runnableWrapper;
    private final ExponentiallyWeightedMovingAverage executionEWMA;
    private final CounterMetric poolWaitTime;

    QueueResizableOpenSearchThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ResizableBlockingQueue<Runnable> workQueue, Function<Runnable, WrappedRunnable> runnableWrapper, ThreadFactory threadFactory, XRejectedExecutionHandler handler, ThreadContext contextHolder) {
        this(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, runnableWrapper, threadFactory, handler, contextHolder, 0.3);
    }

    QueueResizableOpenSearchThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ResizableBlockingQueue<Runnable> workQueue, Function<Runnable, WrappedRunnable> runnableWrapper, ThreadFactory threadFactory, XRejectedExecutionHandler handler, ThreadContext contextHolder, double ewmaAlpha) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler, contextHolder);
        this.workQueue = workQueue;
        this.runnableWrapper = runnableWrapper;
        this.executionEWMA = new ExponentiallyWeightedMovingAverage(ewmaAlpha, 0.0);
        this.poolWaitTime = new CounterMetric();
    }

    @Override
    protected Runnable wrapRunnable(Runnable command) {
        return super.wrapRunnable(this.runnableWrapper.apply(command));
    }

    @Override
    protected Runnable unwrap(Runnable runnable) {
        Runnable unwrapped = super.unwrap(runnable);
        if (unwrapped instanceof WrappedRunnable) {
            return ((WrappedRunnable)unwrapped).unwrap();
        }
        return unwrapped;
    }

    @Override
    public double getTaskExecutionEWMA() {
        return this.executionEWMA.getAverage();
    }

    @Override
    public int getCurrentQueueSize() {
        return this.workQueue.size();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        assert (super.unwrap(r) instanceof TimedRunnable) : "expected only TimedRunnables in queue";
        TimedRunnable timedRunnable = (TimedRunnable)super.unwrap(r);
        boolean failedOrRejected = timedRunnable.getFailedOrRejected();
        long taskExecutionNanos = timedRunnable.getTotalExecutionNanos();
        assert (taskExecutionNanos >= 0L || failedOrRejected && taskExecutionNanos == -1L) : "expected task to always take longer than 0 nanoseconds or have '-1' failure code, got: " + taskExecutionNanos + ", failedOrRejected: " + failedOrRejected;
        if (taskExecutionNanos != -1L) {
            this.executionEWMA.addValue((double)taskExecutionNanos);
        }
        this.poolWaitTime.inc(timedRunnable.getWaitTimeNanos());
    }

    public synchronized int resize(int capacity) {
        ResizableBlockingQueue<Runnable> resizableWorkQueue;
        int currentCapacity = (resizableWorkQueue = this.workQueue).capacity();
        return resizableWorkQueue.adjustCapacity(currentCapacity < capacity ? capacity + 1 : capacity - 1, StrictMath.abs(capacity - currentCapacity), capacity, capacity);
    }

    @Override
    public long getPoolWaitTimeNanos() {
        return this.poolWaitTime.count();
    }
}

