/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.translog.ChannelFactory;
import org.opensearch.index.translog.Checkpoint;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogHeader;
import org.opensearch.index.translog.TranslogOperationHelper;
import org.opensearch.index.translog.TranslogStats;

public class LocalTranslog
extends Translog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, TranslogOperationHelper translogOperationHelper, ChannelFactory channelFactory) throws IOException {
        super(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, translogOperationHelper, channelFactory);
        try {
            Checkpoint checkpoint = LocalTranslog.readCheckpoint(this.location);
            Path nextTranslogFile = this.location.resolve(LocalTranslog.getFilename(checkpoint.generation + 1L));
            Path currentCheckpointFile = this.location.resolve(LocalTranslog.getCommitCheckpointFileName(checkpoint.generation));
            assert (!Files.exists(nextTranslogFile, new LinkOption[0]) || Files.size(nextTranslogFile) <= (long)TranslogHeader.headerSizeInBytes(translogUUID)) : "unexpected translog file: [" + String.valueOf(nextTranslogFile) + "]";
            if (Files.exists(currentCheckpointFile, new LinkOption[0]) && Files.deleteIfExists(nextTranslogFile)) {
                this.logger.warn("deleted previously created, but not yet committed, next generation [{}]. This can happen due to a tragic exception when creating a new generation", (Object)nextTranslogFile.getFileName());
            }
            this.readers.addAll(this.recoverFromFiles(checkpoint));
            if (this.readers.isEmpty()) {
                throw new IllegalStateException("at least one reader must be recovered");
            }
            boolean success = false;
            this.current = null;
            try {
                this.current = this.createWriter(checkpoint.generation + 1L, this.getMinFileGeneration(), checkpoint.globalCheckpoint, persistedSequenceNumberConsumer);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Iterable)this.readers);
                }
            }
        }
        catch (Exception e) {
            IOUtils.closeWhileHandlingException((Closeable)this.current);
            IOUtils.closeWhileHandlingException((Iterable)this.readers);
            throw e;
        }
    }

    public LocalTranslog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer, TranslogOperationHelper translogOperationHelper) throws IOException {
        this(config, translogUUID, deletionPolicy, globalCheckpointSupplier, primaryTermSupplier, persistedSequenceNumberConsumer, translogOperationHelper, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean ensureSynced(Translog.Location location) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            if (location.generation != this.current.getGeneration()) return false;
            this.ensureOpen();
            boolean bl = this.current.syncUpTo(location.translogLocation + (long)location.size);
            return bl;
        }
        catch (Exception ex) {
            this.closeOnTragicEvent(ex);
            throw ex;
        }
    }

    @Override
    public TranslogStats stats() {
        try (ReleasableLock lock = this.readLock.acquire();){
            long uncommittedGen = this.getMinGenerationForSeqNo((long)(this.deletionPolicy.getLocalCheckpointOfSafeCommit() + 1L)).translogFileGeneration;
            TranslogStats translogStats = new TranslogStats(this.totalOperations(), this.sizeInBytes(), this.totalOperationsByMinGen(uncommittedGen), this.sizeInBytesByMinGen(uncommittedGen), this.earliestLastModifiedAge());
            return translogStats;
        }
    }

    @Override
    Releasable drainSync() {
        return () -> {};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        assert (Translog.calledFromOutsideOrViaTragedyClose()) : "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                try {
                    this.current.sync();
                }
                finally {
                    this.closeFilesIfNoPendingRetentionLocks();
                }
            }
            finally {
                this.logger.debug("translog closed");
            }
        }
    }
}

