/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.util.Objects;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.startree.filter.provider.OrdinalFieldMapper;

class IpFieldMapper
extends OrdinalFieldMapper {
    IpFieldMapper() {
    }

    @Override
    Object parseRawField(String field, Object rawValue, MappedFieldType mappedFieldType) throws IllegalArgumentException {
        BytesRef parsedValue = null;
        if (rawValue != null) {
            try {
                Object object = rawValue;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InetAddress.class, BytesRef.class, String.class}, (Object)object2, n)) {
                    case 0: {
                        InetAddress inetAddress = (InetAddress)object2;
                        parsedValue = new BytesRef(InetAddressPoint.encode((InetAddress)inetAddress));
                        break;
                    }
                    case 1: {
                        BytesRef bytesRef = (BytesRef)object2;
                        return bytesRef;
                    }
                    case 2: {
                        String s = (String)object2;
                        InetAddress addr = InetAddress.getByName(s);
                        parsedValue = new BytesRef(InetAddressPoint.encode((InetAddress)addr));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported value type for IP field [" + field + "]: " + rawValue.getClass().getName());
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse IP value for field [" + field + "]", e);
            }
        }
        return parsedValue;
    }
}

