/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.reindex.AbstractBulkByScrollRequest;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.LeaderBulkByScrollTaskState;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.slice.SliceBuilder;
import org.opensearch.transport.client.Client;

class BulkByScrollParallelizationHelper {
    static final int AUTO_SLICE_CEILING = 20;

    private BulkByScrollParallelizationHelper() {
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void startSlicedAction(final Metadata metadata, final Request request, final BulkByScrollTask task, final ActionType<BulkByScrollResponse> action, final ActionListener<BulkByScrollResponse> listener, final Client client, final DiscoveryNode node, final Runnable workerAction) {
        BulkByScrollParallelizationHelper.initTaskState(task, request, client, new ActionListener<Void>(){

            public void onResponse(Void aVoid) {
                BulkByScrollParallelizationHelper.executeSlicedAction(metadata, task, request, (ActionType<BulkByScrollResponse>)action, (ActionListener<BulkByScrollResponse>)listener, client, node, workerAction);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void executeSlicedAction(Metadata metadata, BulkByScrollTask task, Request request, ActionType<BulkByScrollResponse> action, ActionListener<BulkByScrollResponse> listener, Client client, DiscoveryNode node, Runnable workerAction) {
        if (task.isLeader()) {
            BulkByScrollParallelizationHelper.sendSubRequests(metadata, client, action, node.getId(), task, request, listener);
        } else if (task.isWorker()) {
            workerAction.run();
        } else {
            throw new AssertionError((Object)"Task should have been initialized at this point.");
        }
    }

    static <Request extends AbstractBulkByScrollRequest<Request>> void initTaskState(final BulkByScrollTask task, final Request request, Client client, final ActionListener<Void> listener) {
        int configuredSlices = request.getSlices();
        if (configuredSlices == 0) {
            ClusterSearchShardsRequest shardsRequest = new ClusterSearchShardsRequest();
            shardsRequest.indices(request.getSearchRequest().indices());
            client.admin().cluster().searchShards(shardsRequest, (ActionListener)new ActionListener<ClusterSearchShardsResponse>(){

                public void onResponse(ClusterSearchShardsResponse response) {
                    BulkByScrollParallelizationHelper.setWorkerCount(request, task, BulkByScrollParallelizationHelper.countSlicesBasedOnShards(response));
                    listener.onResponse(null);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            BulkByScrollParallelizationHelper.setWorkerCount(request, task, configuredSlices);
            listener.onResponse(null);
        }
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void setWorkerCount(Request request, BulkByScrollTask task, int slices) {
        if (slices > 1) {
            task.setWorkerCount(slices);
        } else {
            SliceBuilder sliceBuilder = request.getSearchRequest().source().slice();
            Integer sliceId = sliceBuilder == null ? null : Integer.valueOf(sliceBuilder.getId());
            task.setWorker(request.getRequestsPerSecond(), sliceId);
        }
    }

    private static int countSlicesBasedOnShards(ClusterSearchShardsResponse response) {
        Map<Index, Integer> countsByIndex = Arrays.stream(response.getGroups()).collect(Collectors.toMap(group -> group.getShardId().getIndex(), group -> 1, (sum, term) -> sum + term));
        HashSet<Integer> counts = new HashSet<Integer>(countsByIndex.values());
        int leastShards = counts.isEmpty() ? 1 : Collections.min(counts);
        return Math.min(leastShards, 20);
    }

    private static <Request extends AbstractBulkByScrollRequest<Request>> void sendSubRequests(Metadata metadata, Client client, ActionType<BulkByScrollResponse> action, String localNodeId, BulkByScrollTask task, Request request, ActionListener<BulkByScrollResponse> listener) {
        LeaderBulkByScrollTaskState worker = task.getLeaderState();
        int totalSlices = worker.getSlices();
        for (String index : request.getSearchRequest().indices()) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null || (Integer)IndexSettings.MAX_SLICES_PER_SCROLL.get(indexMetadata.getSettings()) >= totalSlices) continue;
            throw new IllegalArgumentException("The number of slices [" + totalSlices + "] is too large. It must be less than [" + String.valueOf(IndexSettings.MAX_SLICES_PER_SCROLL.get(indexMetadata.getSettings())) + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
        }
        TaskId parentTaskId = new TaskId(localNodeId, task.getId());
        for (SearchRequest slice : BulkByScrollParallelizationHelper.sliceIntoSubRequests(request.getSearchRequest(), "_id", totalSlices)) {
            AbstractBulkByScrollRequest requestForSlice = request.forSlice(parentTaskId, slice, totalSlices);
            ActionListener sliceListener = ActionListener.wrap(r -> worker.onSliceResponse(listener, slice.source().slice().getId(), r), e -> worker.onSliceFailure(listener, slice.source().slice().getId(), e));
            client.execute(action, (ActionRequest)requestForSlice, sliceListener);
        }
    }

    static SearchRequest[] sliceIntoSubRequests(SearchRequest request, String field, int times) {
        SearchRequest[] slices = new SearchRequest[times];
        for (int slice = 0; slice < times; ++slice) {
            SearchSourceBuilder slicedSource;
            SliceBuilder sliceBuilder = new SliceBuilder(field, slice, times);
            if (request.source() == null) {
                slicedSource = new SearchSourceBuilder().slice(sliceBuilder);
            } else {
                if (request.source().slice() != null) {
                    throw new IllegalStateException("Can't slice a request that already has a slice configuration");
                }
                slicedSource = request.source().shallowCopy().slice(sliceBuilder);
            }
            SearchRequest searchRequest = new SearchRequest(request);
            searchRequest.source(slicedSource);
            slices[slice] = searchRequest;
        }
        return slices;
    }
}

