/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices.state.errorhandler;

import com.amazon.randomcutforest.PredictiveRandomCutForest;
import com.amazon.randomcutforest.parkservices.calibration.ErrorHandler;
import com.amazon.randomcutforest.parkservices.state.errorhandler.ErrorHandlerState;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.PredictiveRandomCutForestMapper;
import com.amazon.randomcutforest.state.statistics.DeviationMapper;
import com.amazon.randomcutforest.state.statistics.DeviationState;
import com.amazon.randomcutforest.statistics.Deviation;

public class ErrorHandlerMapper
implements IStateMapper<ErrorHandler, ErrorHandlerState> {
    public ErrorHandlerState toState(ErrorHandler model) {
        ErrorHandlerState errorHandlerState = new ErrorHandlerState();
        errorHandlerState.setSequenceIndex(model.getSequenceIndex());
        errorHandlerState.setPercentile(model.getPercentile());
        errorHandlerState.setForecastHorizon(model.getForecastHorizon());
        errorHandlerState.setErrorHorizon(model.getErrorHorizon());
        errorHandlerState.setLastDataDeviations(model.getLastDataDeviations());
        DeviationMapper deviationMapper = new DeviationMapper();
        errorHandlerState.setDeviationStates(DeviationMapper.getStates((Deviation[])model.getDeviationList(), (DeviationMapper)deviationMapper));
        errorHandlerState.setLastInput(model.getLastInputs());
        errorHandlerState.setInputLength(model.getInputLength());
        errorHandlerState.setPastForecastsFlattened(model.getPastForecastsFlattened());
        if (model.getEstimator() != null) {
            PredictiveRandomCutForestMapper mapper = new PredictiveRandomCutForestMapper();
            errorHandlerState.setEstimatorState(mapper.toState(model.getEstimator()));
        }
        errorHandlerState.setLowerLimit(model.getLowerLimit());
        errorHandlerState.setUpperLimit(model.getUpperLimit());
        return errorHandlerState;
    }

    public ErrorHandler toModel(ErrorHandlerState state, long seed) {
        PredictiveRandomCutForest forest = null;
        PredictiveRandomCutForestMapper mapper = new PredictiveRandomCutForestMapper();
        if (state.getEstimatorState() != null) {
            forest = (PredictiveRandomCutForest)mapper.toModel((Object)state.getEstimatorState());
        }
        DeviationMapper deviationMapper = new DeviationMapper();
        ErrorHandler errorHandler = new ErrorHandler(state.getErrorHorizon(), state.getForecastHorizon(), state.getSequenceIndex(), state.getPercentile(), state.getInputLength(), state.getPastForecastsFlattened(), state.getLastDataDeviations(), state.getLastInput(), DeviationMapper.getDeviations((DeviationState[])state.getDeviationStates(), (DeviationMapper)deviationMapper), forest, null);
        errorHandler.setUpperLimit(state.getUpperLimit());
        errorHandler.setLowerLimit(state.getLowerLimit());
        return errorHandler;
    }
}

