/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.translog.ReplicationTranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogReader;
import org.opensearch.index.translog.TranslogWriter;
import org.opensearch.replication.ReplicationPlugin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\tJ\u001e\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/index/translog/ReplicationTranslogDeletionPolicy;", "Lorg/opensearch/index/translog/TranslogDeletionPolicy;", "indexSettings", "Lorg/opensearch/index/IndexSettings;", "retentionLeasesSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/index/seqno/RetentionLeases;", "(Lorg/opensearch/index/IndexSettings;Ljava/util/function/Supplier;)V", "replicationRetentionSizeInBytes", "", "retentionAgeInMillis", "retentionSizeInBytes", "retentionTotalFiles", "", "translogPruningEnabled", "", "getIndexTranslogPruningEnabled", "getRetentionSizeInBytes", "minTranslogGenRequired", "readers", "", "Lorg/opensearch/index/translog/TranslogReader;", "writer", "Lorg/opensearch/index/translog/TranslogWriter;", "setRetentionAgeInMillis", "", "ageInMillis", "setRetentionSizeInBytes", "bytes", "setRetentionTotalFiles", "Companion", "opensearch-cross-cluster-replication"})
public final class ReplicationTranslogDeletionPolicy
extends TranslogDeletionPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<RetentionLeases> retentionLeasesSupplier;
    private volatile boolean translogPruningEnabled;
    private volatile long replicationRetentionSizeInBytes;
    private volatile long retentionSizeInBytes;
    private volatile long retentionAgeInMillis;
    private volatile int retentionTotalFiles;

    /*
     * Unable to fully structure code
     */
    public ReplicationTranslogDeletionPolicy(@NotNull IndexSettings indexSettings, @NotNull Supplier<RetentionLeases> retentionLeasesSupplier) {
        Intrinsics.checkNotNullParameter((Object)indexSettings, (String)"indexSettings");
        Intrinsics.checkNotNullParameter(retentionLeasesSupplier, (String)"retentionLeasesSupplier");
        super();
        this.retentionLeasesSupplier = retentionLeasesSupplier;
        if (!indexSettings.isSoftDeleteEnabled()) ** GOTO lbl-1000
        v0 = ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING().get(indexSettings.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
        if (((Boolean)v0).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        this.translogPruningEnabled = v1;
        this.replicationRetentionSizeInBytes = ((ByteSizeValue)ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_RETENTION_SIZE().get(indexSettings.getSettings())).getBytes();
        this.retentionSizeInBytes = indexSettings.getTranslogRetentionSize().getBytes();
        this.retentionAgeInMillis = indexSettings.getTranslogRetentionAge().getMillis();
        this.retentionTotalFiles = indexSettings.getTranslogRetentionTotalFiles();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_PRUNING_ENABLED_SETTING(), (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, _init_$lambda$0(org.opensearch.index.translog.ReplicationTranslogDeletionPolicy org.opensearch.index.IndexSettings boolean ), (Ljava/lang/Boolean;)V)((ReplicationTranslogDeletionPolicy)this, (IndexSettings)indexSettings));
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(ReplicationPlugin.Companion.getREPLICATION_INDEX_TRANSLOG_RETENTION_SIZE(), (Consumer<ByteSizeValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, _init_$lambda$1(org.opensearch.index.translog.ReplicationTranslogDeletionPolicy org.opensearch.core.common.unit.ByteSizeValue ), (Lorg/opensearch/core/common/unit/ByteSizeValue;)V)((ReplicationTranslogDeletionPolicy)this));
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING, (Consumer<ByteSizeValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, _init_$lambda$2(org.opensearch.index.translog.ReplicationTranslogDeletionPolicy org.opensearch.index.IndexSettings org.opensearch.core.common.unit.ByteSizeValue ), (Lorg/opensearch/core/common/unit/ByteSizeValue;)V)((ReplicationTranslogDeletionPolicy)this, (IndexSettings)indexSettings));
    }

    public final long getRetentionSizeInBytes() {
        if (this.getIndexTranslogPruningEnabled()) {
            return this.replicationRetentionSizeInBytes;
        }
        return this.retentionSizeInBytes;
    }

    public final boolean getIndexTranslogPruningEnabled() {
        return this.translogPruningEnabled;
    }

    public void setRetentionSizeInBytes(long bytes) {
        this.retentionSizeInBytes = bytes;
    }

    public void setRetentionAgeInMillis(long ageInMillis) {
        this.retentionAgeInMillis = ageInMillis;
    }

    protected void setRetentionTotalFiles(int retentionTotalFiles) {
        this.retentionTotalFiles = retentionTotalFiles;
    }

    public synchronized long minTranslogGenRequired(@NotNull List<? extends TranslogReader> readers, @NotNull TranslogWriter writer) throws IOException {
        Intrinsics.checkNotNullParameter(readers, (String)"readers");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        return Companion.minTranslogGenRequired(readers, writer, this.getIndexTranslogPruningEnabled(), this.getRetentionSizeInBytes(), this.retentionAgeInMillis, this.retentionTotalFiles, this.getMinTranslogGenRequiredByLocks(), this.retentionLeasesSupplier);
    }

    private static final void _init_$lambda$0(ReplicationTranslogDeletionPolicy this$0, IndexSettings $indexSettings, boolean value) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$indexSettings, (String)"$indexSettings");
        this$0.translogPruningEnabled = $indexSettings.isSoftDeleteEnabled() ? value : false;
    }

    private static final void _init_$lambda$1(ReplicationTranslogDeletionPolicy this$0, ByteSizeValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.replicationRetentionSizeInBytes = value.getBytes();
    }

    private static final void _init_$lambda$2(ReplicationTranslogDeletionPolicy this$0, IndexSettings $indexSettings, ByteSizeValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$indexSettings, (String)"$indexSettings");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this$0.retentionSizeInBytes = $indexSettings.isSoftDeleteEnabled() ? -1L : value.getBytes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJR\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/index/translog/ReplicationTranslogDeletionPolicy$Companion;", "", "()V", "getMinTranslogGenByRetentionLease", "", "readers", "", "Lorg/opensearch/index/translog/TranslogReader;", "writer", "Lorg/opensearch/index/translog/TranslogWriter;", "retentionLeasesSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/index/seqno/RetentionLeases;", "minTranslogGenRequired", "translogPruningEnabled", "", "retentionSizeInBytes", "retentionAgeInMillis", "retentionTotalFiles", "", "minTranslogGenRequiredByLocks", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public final long minTranslogGenRequired(@NotNull List<? extends TranslogReader> readers, @NotNull TranslogWriter writer, boolean translogPruningEnabled, long retentionSizeInBytes, long retentionAgeInMillis, int retentionTotalFiles, long minTranslogGenRequiredByLocks, @NotNull Supplier<RetentionLeases> retentionLeasesSupplier) {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(retentionLeasesSupplier, (String)"retentionLeasesSupplier");
            long minBySize = TranslogDeletionPolicy.getMinTranslogGenBySize(readers, (TranslogWriter)writer, (long)retentionSizeInBytes);
            long minByRetentionLeasesAndSize = Long.MAX_VALUE;
            if (translogPruningEnabled) {
                long minByRetentionLeases = this.getMinTranslogGenByRetentionLease(readers, writer, retentionLeasesSupplier);
                minByRetentionLeasesAndSize = RangesKt.coerceAtLeast((long)minBySize, (long)minByRetentionLeases);
            }
            long minByAge = TranslogDeletionPolicy.getMinTranslogGenByAge(readers, (TranslogWriter)writer, (long)retentionAgeInMillis, (long)System.currentTimeMillis());
            long minByAgeAndSize = minBySize == Long.MIN_VALUE && minByAge == Long.MIN_VALUE ? Long.MAX_VALUE : RangesKt.coerceAtLeast((long)minByAge, (long)minBySize);
            long minByNumFiles = TranslogDeletionPolicy.getMinTranslogGenByTotalFiles(readers, (TranslogWriter)writer, (int)retentionTotalFiles);
            long minByLocks = minTranslogGenRequiredByLocks;
            long minByTranslogGenSettings = RangesKt.coerceAtMost((long)RangesKt.coerceAtLeast((long)minByAgeAndSize, (long)minByNumFiles), (long)minByLocks);
            return RangesKt.coerceAtMost((long)minByTranslogGenSettings, (long)minByRetentionLeasesAndSize);
        }

        public final long getMinTranslogGenByRetentionLease(@NotNull List<? extends TranslogReader> readers, @NotNull TranslogWriter writer, @NotNull Supplier<RetentionLeases> retentionLeasesSupplier) {
            Intrinsics.checkNotNullParameter(readers, (String)"readers");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(retentionLeasesSupplier, (String)"retentionLeasesSupplier");
            long minGen = writer.getGeneration();
            long minimumRetainingSequenceNumber2 = retentionLeasesSupplier.get().leases().stream().mapToLong(arg_0 -> Companion.getMinTranslogGenByRetentionLease$lambda$0(getMinTranslogGenByRetentionLease.minimumRetainingSequenceNumber.1.INSTANCE, arg_0)).min().orElse(Long.MAX_VALUE);
            for (int i = readers.size() - 1; -1 < i; --i) {
                TranslogReader reader = readers.get(i);
                if (reader.getMinSeqNo() > minimumRetainingSequenceNumber2 || reader.getMaxSeqNo() < minimumRetainingSequenceNumber2) continue;
                minGen = RangesKt.coerceAtMost((long)minGen, (long)reader.getGeneration());
            }
            return minGen;
        }

        private static final long getMinTranslogGenByRetentionLease$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return ((Number)$tmp0.invoke(p0)).longValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

