function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useState, useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../../common';
import { htmlIdGenerator } from '../../../services/accessibility';
import { OuiIcon } from '../../icon';
var baseClassName = 'ouiSwitch';
var colorToClassNameMap = {
  primary: "".concat(baseClassName, "--primary"),
  accent: "".concat(baseClassName, "--accent"),
  secondary: "".concat(baseClassName, "--secondary"),
  success: "".concat(baseClassName, "--success"),
  warning: "".concat(baseClassName, "--warning"),
  danger: "".concat(baseClassName, "--danger"),
  ghost: "".concat(baseClassName, "--ghost"),
  text: "".concat(baseClassName, "--text")
};
export var COLORS = keysOf(colorToClassNameMap);
var displayToClassNameMap = {
  base: "".concat(baseClassName, "--base"),
  empty: null
};
export var DISPLAYS = keysOf(displayToClassNameMap);
export var OuiSwitch = function OuiSwitch(_ref) {
  var label = _ref.label,
    id = _ref.id,
    checked = _ref.checked,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    onChange = _ref.onChange,
    className = _ref.className,
    _ref$showLabel = _ref.showLabel,
    showLabel = _ref$showLabel === void 0 ? true : _ref$showLabel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    labelProps = _ref.labelProps,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'empty' : _ref$display,
    rest = _objectWithoutProperties(_ref, ["label", "id", "checked", "disabled", "compressed", "onChange", "className", "showLabel", "type", "labelProps", "color", "display"]);
  var _useState = useState(id || htmlIdGenerator()()),
    _useState2 = _slicedToArray(_useState, 1),
    switchId = _useState2[0];
  var _useState3 = useState((labelProps === null || labelProps === void 0 ? void 0 : labelProps.id) || htmlIdGenerator()()),
    _useState4 = _slicedToArray(_useState3, 1),
    labelId = _useState4[0];
  var onClick = useCallback(function (e) {
    if (disabled) {
      return;
    }
    var event = e;
    event.target.checked = !checked;
    onChange(event);
  }, [checked, disabled, onChange]);
  var classes = classNames('ouiSwitch', color && colorToClassNameMap[color], display && displayToClassNameMap[display], {
    'ouiSwitch--compressed': compressed,
    'ouiSwitch-isDisabled': disabled
  }, className);
  var labelClasses = classNames('ouiSwitch__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  if (showLabel === false && typeof label !== 'string') {
    console.warn('OuiSwitch `label` must be a string when `showLabel` is false.');
  }
  return /*#__PURE__*/React.createElement("div", {
    className: classes
  }, /*#__PURE__*/React.createElement("button", _extends({
    id: switchId,
    "aria-checked": checked || false,
    className: "ouiSwitch__button",
    role: "switch",
    type: type,
    disabled: disabled,
    onClick: onClick,
    "aria-label": showLabel ? undefined : label,
    "aria-labelledby": showLabel ? labelId : undefined
  }, rest), /*#__PURE__*/React.createElement("span", {
    className: "ouiSwitch__body"
  }, /*#__PURE__*/React.createElement("span", {
    className: "ouiSwitch__thumb"
  }), /*#__PURE__*/React.createElement("span", {
    className: "ouiSwitch__track"
  }, !compressed && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(OuiIcon, {
    type: "cross",
    size: "m",
    className: "ouiSwitch__icon"
  }), /*#__PURE__*/React.createElement(OuiIcon, {
    type: "check",
    size: "m",
    className: "ouiSwitch__icon ouiSwitch__icon--checked"
  }))))), showLabel &&
  /*#__PURE__*/
  // <button> + <label> has poor screen reader support.
  // Click handler added to simulate natural, secondary <label> interactivity.
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  React.createElement("span", _extends({}, labelProps, {
    className: labelClasses,
    id: labelId,
    onClick: onClick
  }), label));
};

// @internal
OuiSwitch.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * Whether to render the text label
       */
  showLabel: PropTypes.bool,
  /**
       * Must be a string if `showLabel` prop is false
       */
  label: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.string.isRequired]).isRequired,
  checked: PropTypes.bool.isRequired,
  onChange: PropTypes.func.isRequired,
  /**
       * Any of the named color palette options.
       * **`subdued` set to be DEPRECATED, use `text` instead**
       */
  color: PropTypes.oneOf(["primary", "accent", "secondary", "success", "warning", "danger", "ghost", "text"]),
  disabled: PropTypes.bool,
  compressed: PropTypes.bool,
  type: PropTypes.oneOf(["submit", "reset", "button"]),
  /**
       * Object of props passed to the label's <span/>
       */
  labelProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  /**
       * Sets the display style for matching other OuiButton types.
       * `base` is equivalent to a typical OuiButton
       * `empty` (default) is equivalent to an OuiButtonEmpty
       */
  display: PropTypes.oneOf(["base", "empty"])
};
// @internal
export var OuiCompressedSwitch = function OuiCompressedSwitch(props) {
  return /*#__PURE__*/React.createElement(OuiSwitch, _extends({}, props, {
    compressed: true
  }));
};

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { EuiSwitch, EuiCompressedSwitch } from '../../../eui_components/form/switch/switch';