"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTabbedContent", {
  enumerable: true,
  get: function get() {
    return _tabbed_content.EuiTabbedContent;
  }
});
exports.OuiTabbedContent = exports.AUTOFOCUS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _tabs = require("../tabs");
var _tab = require("../tab");
var _tabbed_content = require("../../../eui_components/tabs/tabbed_content/tabbed_content");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Marked as const so type is `['initial', 'selected']` instead of `string[]`
 */
var AUTOFOCUS = ['initial', 'selected'];
exports.AUTOFOCUS = AUTOFOCUS;
var OuiTabbedContent = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiTabbedContent, _Component);
  var _super = _createSuper(OuiTabbedContent);
  function OuiTabbedContent(props) {
    var _this;
    (0, _classCallCheck2.default)(this, OuiTabbedContent);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "rootId", (0, _services.htmlIdGenerator)()());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "tabsRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "focusTab", function () {
      var targetTab = _this.tabsRef.current.querySelector("#".concat(_this.state.selectedTabId));
      targetTab.focus();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "initializeFocus", function () {
      if (!_this.state.inFocus && _this.props.autoFocus === 'selected') {
        // Must wait for setState to finish before calling `.focus()`
        // as the focus call triggers a blur on the first tab
        _this.setState({
          inFocus: true
        }, function () {
          _this.focusTab();
        });
      }
    });
    // todo: figure out type for blurEvent
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "removeFocus", function (blurEvent) {
      // only set inFocus to false if the wrapping div doesn't contain the now-focusing element
      var currentTarget = blurEvent.currentTarget;
      var relatedTarget = blurEvent.relatedTarget;
      if (currentTarget.contains(relatedTarget) === false) {
        _this.setState({
          inFocus: false
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onTabClick", function (selectedTab) {
      var _this$props = _this.props,
        onTabClick = _this$props.onTabClick,
        externalSelectedTab = _this$props.selectedTab;
      if (onTabClick) {
        onTabClick(selectedTab);
      }

      // Only track selection state if it's not controlled externally.
      _this.setState(function (prevState) {
        return {
          selectedTabId: externalSelectedTab ? prevState.selectedTabId : selectedTab.id,
          preservedTabsId: [].concat((0, _toConsumableArray2.default)(prevState.preservedTabsId), [selectedTab.id])
        };
      });
    });
    var initialSelectedTab = props.initialSelectedTab,
      _selectedTab = props.selectedTab,
      tabs = props.tabs; // Only track selection state if it's not controlled externally.
    var selectedTabId;
    if (!_selectedTab) {
      selectedTabId = initialSelectedTab && initialSelectedTab.id || tabs[0].id;
    }
    var preservedTabsId = [];
    preservedTabsId.push(_selectedTab ? _selectedTab.id : initialSelectedTab && initialSelectedTab.id || tabs[0].id);
    _this.state = {
      selectedTabId: selectedTabId,
      preservedTabsId: preservedTabsId,
      inFocus: false
    };
    return _this;
  }
  (0, _createClass2.default)(OuiTabbedContent, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // IE11 doesn't support the `relatedTarget` event property for blur events
      // but does add it for focusout. React doesn't support `onFocusOut` so here we are.
      if (this.tabsRef.current) {
        // Current short-term solution for event listener (see https://github.com/elastic/eui/pull/2717)
        this.tabsRef.current.addEventListener('focusout', this.removeFocus);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.tabsRef.current) {
        // Current short-term solution for event listener (see https://github.com/elastic/eui/pull/2717)
        this.tabsRef.current.removeEventListener('focusout', this.removeFocus);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        className = _this$props2.className,
        display = _this$props2.display,
        expand = _this$props2.expand,
        initialSelectedTab = _this$props2.initialSelectedTab,
        onTabClick = _this$props2.onTabClick,
        externalSelectedTab = _this$props2.selectedTab,
        size = _this$props2.size,
        tabs = _this$props2.tabs,
        autoFocus = _this$props2.autoFocus,
        preserveTabContent = _this$props2.preserveTabContent,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, ["className", "display", "expand", "initialSelectedTab", "onTabClick", "selectedTab", "size", "tabs", "autoFocus", "preserveTabContent"]); // Allow the consumer to control tab selection.
      var selectedTab = externalSelectedTab || tabs.find(function (tab) {
        return tab.id === _this2.state.selectedTabId;
      });
      var _ref = selectedTab,
        selectedTabContent = _ref.content,
        selectedTabId = _ref.id;
      return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: className
      }, rest), /*#__PURE__*/_react.default.createElement(_tabs.OuiTabs, {
        ref: this.tabsRef,
        expand: expand,
        display: display,
        size: size,
        onFocus: this.initializeFocus
      }, tabs.map(function (tab) {
        var id = tab.id,
          name = tab.name,
          content = tab.content,
          tabProps = (0, _objectWithoutProperties2.default)(tab, ["id", "name", "content"]);
        var props = _objectSpread(_objectSpread({
          key: id,
          id: id
        }, tabProps), {}, {
          onClick: function onClick() {
            return _this2.onTabClick(tab);
          },
          isSelected: tab === selectedTab,
          'aria-controls': "".concat(_this2.rootId)
        });
        return /*#__PURE__*/_react.default.createElement(_tab.OuiTab, props, name);
      })), !preserveTabContent && /*#__PURE__*/_react.default.createElement("div", {
        role: "tabpanel",
        id: "".concat(this.rootId),
        "aria-labelledby": selectedTabId
      }, selectedTabContent), preserveTabContent && tabs.map(function (tab) {
        var id = tab.id,
          content = tab.content;
        if (_this2.state.preservedTabsId.includes(id)) {
          return /*#__PURE__*/_react.default.createElement("div", {
            key: id,
            role: "tabpanel",
            id: id,
            "aria-labelledby": id,
            style: id === selectedTabId ? undefined : {
              display: 'none'
            }
          }, content);
        }
      }));
    }
  }]);
  return OuiTabbedContent;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */
exports.OuiTabbedContent = OuiTabbedContent;
(0, _defineProperty2.default)(OuiTabbedContent, "defaultProps", {
  autoFocus: 'initial',
  preserveTabContent: false
});
OuiTabbedContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
       * When tabbing into the tabs, set the focus on `initial` for the first tab,
       * or `selected` for the currently selected tab. Best use case is for inside of
       * overlay content like popovers or flyouts.
       */
  autoFocus: _propTypes.default.oneOf(["initial", "selected"]),
  /**
       * Choose `default` or alternative `condensed` display styles
       */
  display: _propTypes.default.oneOf(["condensed", "default"]),
  /**
       * Evenly stretches each tab to fill the horizontal space
       */
  expand: _propTypes.default.bool,
  /**
       * Use this prop to set the initially selected tab while letting the tabbed content component
       * control selection state internally
       */
  initialSelectedTab: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.node.isRequired,
    content: _propTypes.default.node.isRequired
  }),
  onTabClick: _propTypes.default.func,
  /**
       * Use this prop if you want to control selection state within the owner component
       */
  selectedTab: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.node.isRequired,
    content: _propTypes.default.node.isRequired
  }),
  size: _propTypes.default.oneOf(["s", "m", "l"]),
  /**
       * Each tab needs id and content properties, so we can associate it with its panel for accessibility.
       * The name property (a node) is also required to display to the user.
       */
  tabs: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    name: _propTypes.default.node.isRequired,
    content: _propTypes.default.node.isRequired
  }).isRequired).isRequired,
  /**
       * Use this prop to allow tab content stay in dom, if the tab has been selected.
       */
  preserveTabContent: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */