/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionTrackingSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.EnaSrdSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6PrefixSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworkInterfaceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::associatePublicIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").unmarshallLocationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::deleteOnTermination)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::description)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::deviceIndex)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::groups)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6AddressCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("ipv6AddressCount").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6Addresses)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::networkInterfaceId)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::privateIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::privateIpAddresses)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateIpAddressSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::subnetId)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociateCarrierIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::associateCarrierIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::associateCarrierIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress").unmarshallLocationName("AssociateCarrierIpAddress").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::interfaceType)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("InterfaceType").build()}).build();
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetworkCardIndex").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::networkCardIndex)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::networkCardIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").unmarshallLocationName("NetworkCardIndex").build()}).build();
    private static final SdkField<List<Ipv4PrefixSpecificationRequest>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv4Prefixes)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix").unmarshallLocationName("Ipv4Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv4PrefixSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4PrefixCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv4PrefixCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv4PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").unmarshallLocationName("Ipv4PrefixCount").build()}).build();
    private static final SdkField<List<Ipv6PrefixSpecificationRequest>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6Prefixes)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix").unmarshallLocationName("Ipv6Prefix").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6PrefixSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6PrefixCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6PrefixCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6PrefixCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").unmarshallLocationName("Ipv6PrefixCount").build()}).build();
    private static final SdkField<Boolean> PRIMARY_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrimaryIpv6").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::primaryIpv6)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::primaryIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryIpv6").unmarshallLocationName("PrimaryIpv6").build()}).build();
    private static final SdkField<EnaSrdSpecificationRequest> ENA_SRD_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSrdSpecification").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::enaSrdSpecification)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::enaSrdSpecification)).constructor(EnaSrdSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSrdSpecification").unmarshallLocationName("EnaSrdSpecification").build()}).build();
    private static final SdkField<ConnectionTrackingSpecificationRequest> CONNECTION_TRACKING_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionTrackingSpecification").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::connectionTrackingSpecification)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::connectionTrackingSpecification)).constructor(ConnectionTrackingSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTrackingSpecification").unmarshallLocationName("ConnectionTrackingSpecification").build()}).build();
    private static final SdkField<Integer> ENA_QUEUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnaQueueCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::enaQueueCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::enaQueueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaQueueCount").unmarshallLocationName("EnaQueueCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD, DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD, ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, INTERFACE_TYPE_FIELD, NETWORK_CARD_INDEX_FIELD, IPV4_PREFIXES_FIELD, IPV4_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD, IPV6_PREFIX_COUNT_FIELD, PRIMARY_IPV6_FIELD, ENA_SRD_SPECIFICATION_FIELD, CONNECTION_TRACKING_SPECIFICATION_FIELD, ENA_QUEUE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceNetworkInterfaceSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean associatePublicIpAddress;
    private final Boolean deleteOnTermination;
    private final String description;
    private final Integer deviceIndex;
    private final List<String> groups;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String networkInterfaceId;
    private final String privateIpAddress;
    private final List<PrivateIpAddressSpecification> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;
    private final String subnetId;
    private final Boolean associateCarrierIpAddress;
    private final String interfaceType;
    private final Integer networkCardIndex;
    private final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes;
    private final Integer ipv4PrefixCount;
    private final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes;
    private final Integer ipv6PrefixCount;
    private final Boolean primaryIpv6;
    private final EnaSrdSpecificationRequest enaSrdSpecification;
    private final ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
    private final Integer enaQueueCount;

    private InstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.interfaceType = builder.interfaceType;
        this.networkCardIndex = builder.networkCardIndex;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.primaryIpv6 = builder.primaryIpv6;
        this.enaSrdSpecification = builder.enaSrdSpecification;
        this.connectionTrackingSpecification = builder.connectionTrackingSpecification;
        this.enaQueueCount = builder.enaQueueCount;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public final String description() {
        return this.description;
    }

    public final Integer deviceIndex() {
        return this.deviceIndex;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<PrivateIpAddressSpecification> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final Boolean associateCarrierIpAddress() {
        return this.associateCarrierIpAddress;
    }

    public final String interfaceType() {
        return this.interfaceType;
    }

    public final Integer networkCardIndex() {
        return this.networkCardIndex;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv4PrefixSpecificationRequest> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public final Integer ipv4PrefixCount() {
        return this.ipv4PrefixCount;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<Ipv6PrefixSpecificationRequest> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public final Integer ipv6PrefixCount() {
        return this.ipv6PrefixCount;
    }

    public final Boolean primaryIpv6() {
        return this.primaryIpv6;
    }

    public final EnaSrdSpecificationRequest enaSrdSpecification() {
        return this.enaSrdSpecification;
    }

    public final ConnectionTrackingSpecificationRequest connectionTrackingSpecification() {
        return this.connectionTrackingSpecification;
    }

    public final Integer enaQueueCount() {
        return this.enaQueueCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSrdSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTrackingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaQueueCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification)obj;
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.associateCarrierIpAddress(), other.associateCarrierIpAddress()) && Objects.equals(this.interfaceType(), other.interfaceType()) && Objects.equals(this.networkCardIndex(), other.networkCardIndex()) && this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes()) && Objects.equals(this.ipv4PrefixCount(), other.ipv4PrefixCount()) && this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes()) && Objects.equals(this.ipv6PrefixCount(), other.ipv6PrefixCount()) && Objects.equals(this.primaryIpv6(), other.primaryIpv6()) && Objects.equals(this.enaSrdSpecification(), other.enaSrdSpecification()) && Objects.equals(this.connectionTrackingSpecification(), other.connectionTrackingSpecification()) && Objects.equals(this.enaQueueCount(), other.enaQueueCount());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceNetworkInterfaceSpecification").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Description", (Object)this.description()).add("DeviceIndex", (Object)this.deviceIndex()).add("Groups", this.hasGroups() ? this.groups() : null).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("SubnetId", (Object)this.subnetId()).add("AssociateCarrierIpAddress", (Object)this.associateCarrierIpAddress()).add("InterfaceType", (Object)this.interfaceType()).add("NetworkCardIndex", (Object)this.networkCardIndex()).add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).add("Ipv4PrefixCount", (Object)this.ipv4PrefixCount()).add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).add("Ipv6PrefixCount", (Object)this.ipv6PrefixCount()).add("PrimaryIpv6", (Object)this.primaryIpv6()).add("EnaSrdSpecification", (Object)this.enaSrdSpecification()).add("ConnectionTrackingSpecification", (Object)this.connectionTrackingSpecification()).add("EnaQueueCount", (Object)this.enaQueueCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AssociateCarrierIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associateCarrierIpAddress()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceType()));
            }
            case "NetworkCardIndex": {
                return Optional.ofNullable(clazz.cast(this.networkCardIndex()));
            }
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
            case "Ipv4PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv4PrefixCount()));
            }
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
            case "Ipv6PrefixCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6PrefixCount()));
            }
            case "PrimaryIpv6": {
                return Optional.ofNullable(clazz.cast(this.primaryIpv6()));
            }
            case "EnaSrdSpecification": {
                return Optional.ofNullable(clazz.cast(this.enaSrdSpecification()));
            }
            case "ConnectionTrackingSpecification": {
                return Optional.ofNullable(clazz.cast(this.connectionTrackingSpecification()));
            }
            case "EnaQueueCount": {
                return Optional.ofNullable(clazz.cast(this.enaQueueCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("SecurityGroupId", GROUPS_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("PrivateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("AssociateCarrierIpAddress", ASSOCIATE_CARRIER_IP_ADDRESS_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("Ipv4Prefix", IPV4_PREFIXES_FIELD);
        map.put("Ipv4PrefixCount", IPV4_PREFIX_COUNT_FIELD);
        map.put("Ipv6Prefix", IPV6_PREFIXES_FIELD);
        map.put("Ipv6PrefixCount", IPV6_PREFIX_COUNT_FIELD);
        map.put("PrimaryIpv6", PRIMARY_IPV6_FIELD);
        map.put("EnaSrdSpecification", ENA_SRD_SPECIFICATION_FIELD);
        map.put("ConnectionTrackingSpecification", CONNECTION_TRACKING_SPECIFICATION_FIELD);
        map.put("EnaQueueCount", ENA_QUEUE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean deleteOnTermination;
        private String description;
        private Integer deviceIndex;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private String privateIpAddress;
        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private String subnetId;
        private Boolean associateCarrierIpAddress;
        private String interfaceType;
        private Integer networkCardIndex;
        private List<Ipv4PrefixSpecificationRequest> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv4PrefixCount;
        private List<Ipv6PrefixSpecificationRequest> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6PrefixCount;
        private Boolean primaryIpv6;
        private EnaSrdSpecificationRequest enaSrdSpecification;
        private ConnectionTrackingSpecificationRequest connectionTrackingSpecification;
        private Integer enaQueueCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceSpecification model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.deleteOnTermination(model.deleteOnTermination);
            this.description(model.description);
            this.deviceIndex(model.deviceIndex);
            this.groups(model.groups);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.subnetId(model.subnetId);
            this.associateCarrierIpAddress(model.associateCarrierIpAddress);
            this.interfaceType(model.interfaceType);
            this.networkCardIndex(model.networkCardIndex);
            this.ipv4Prefixes(model.ipv4Prefixes);
            this.ipv4PrefixCount(model.ipv4PrefixCount);
            this.ipv6Prefixes(model.ipv6Prefixes);
            this.ipv6PrefixCount(model.ipv6PrefixCount);
            this.primaryIpv6(model.primaryIpv6);
            this.enaSrdSpecification(model.enaSrdSpecification);
            this.connectionTrackingSpecification(model.connectionTrackingSpecification);
            this.enaQueueCount(model.enaQueueCount);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            List<PrivateIpAddressSpecification.Builder> result = PrivateIpAddressSpecificationListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (PrivateIpAddressSpecification)((PrivateIpAddressSpecification.Builder)PrivateIpAddressSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return this.associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return this.networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final List<Ipv4PrefixSpecificationRequest.Builder> getIpv4Prefixes() {
            List<Ipv4PrefixSpecificationRequest.Builder> result = Ipv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<Ipv4PrefixSpecificationRequest.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> ipv4Prefixes) {
            this.ipv4Prefixes = Ipv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder> ... ipv4Prefixes) {
            this.ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> (Ipv4PrefixSpecificationRequest)((Ipv4PrefixSpecificationRequest.Builder)Ipv4PrefixSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return this.ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<Ipv6PrefixSpecificationRequest.Builder> getIpv6Prefixes() {
            List<Ipv6PrefixSpecificationRequest.Builder> result = Ipv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<Ipv6PrefixSpecificationRequest.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> ipv6Prefixes) {
            this.ipv6Prefixes = Ipv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder> ... ipv6Prefixes) {
            this.ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> (Ipv6PrefixSpecificationRequest)((Ipv6PrefixSpecificationRequest.Builder)Ipv6PrefixSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return this.ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final Boolean getPrimaryIpv6() {
            return this.primaryIpv6;
        }

        public final void setPrimaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
        }

        @Override
        public final Builder primaryIpv6(Boolean primaryIpv6) {
            this.primaryIpv6 = primaryIpv6;
            return this;
        }

        public final EnaSrdSpecificationRequest.Builder getEnaSrdSpecification() {
            return this.enaSrdSpecification != null ? this.enaSrdSpecification.toBuilder() : null;
        }

        public final void setEnaSrdSpecification(EnaSrdSpecificationRequest.BuilderImpl enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification != null ? enaSrdSpecification.build() : null;
        }

        @Override
        public final Builder enaSrdSpecification(EnaSrdSpecificationRequest enaSrdSpecification) {
            this.enaSrdSpecification = enaSrdSpecification;
            return this;
        }

        public final ConnectionTrackingSpecificationRequest.Builder getConnectionTrackingSpecification() {
            return this.connectionTrackingSpecification != null ? this.connectionTrackingSpecification.toBuilder() : null;
        }

        public final void setConnectionTrackingSpecification(ConnectionTrackingSpecificationRequest.BuilderImpl connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification != null ? connectionTrackingSpecification.build() : null;
        }

        @Override
        public final Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest connectionTrackingSpecification) {
            this.connectionTrackingSpecification = connectionTrackingSpecification;
            return this;
        }

        public final Integer getEnaQueueCount() {
            return this.enaQueueCount;
        }

        public final void setEnaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
        }

        @Override
        public final Builder enaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
            return this;
        }

        public InstanceNetworkInterfaceSpecification build() {
            return new InstanceNetworkInterfaceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder description(String var1);

        public Builder deviceIndex(Integer var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> var1);

        public Builder privateIpAddresses(PrivateIpAddressSpecification ... var1);

        public Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder subnetId(String var1);

        public Builder associateCarrierIpAddress(Boolean var1);

        public Builder interfaceType(String var1);

        public Builder networkCardIndex(Integer var1);

        public Builder ipv4Prefixes(Collection<Ipv4PrefixSpecificationRequest> var1);

        public Builder ipv4Prefixes(Ipv4PrefixSpecificationRequest ... var1);

        public Builder ipv4Prefixes(Consumer<Ipv4PrefixSpecificationRequest.Builder> ... var1);

        public Builder ipv4PrefixCount(Integer var1);

        public Builder ipv6Prefixes(Collection<Ipv6PrefixSpecificationRequest> var1);

        public Builder ipv6Prefixes(Ipv6PrefixSpecificationRequest ... var1);

        public Builder ipv6Prefixes(Consumer<Ipv6PrefixSpecificationRequest.Builder> ... var1);

        public Builder ipv6PrefixCount(Integer var1);

        public Builder primaryIpv6(Boolean var1);

        public Builder enaSrdSpecification(EnaSrdSpecificationRequest var1);

        default public Builder enaSrdSpecification(Consumer<EnaSrdSpecificationRequest.Builder> enaSrdSpecification) {
            return this.enaSrdSpecification((EnaSrdSpecificationRequest)((EnaSrdSpecificationRequest.Builder)EnaSrdSpecificationRequest.builder().applyMutation(enaSrdSpecification)).build());
        }

        public Builder connectionTrackingSpecification(ConnectionTrackingSpecificationRequest var1);

        default public Builder connectionTrackingSpecification(Consumer<ConnectionTrackingSpecificationRequest.Builder> connectionTrackingSpecification) {
            return this.connectionTrackingSpecification((ConnectionTrackingSpecificationRequest)((ConnectionTrackingSpecificationRequest.Builder)ConnectionTrackingSpecificationRequest.builder().applyMutation(connectionTrackingSpecification)).build());
        }

        public Builder enaQueueCount(Integer var1);
    }
}

