/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientConnectOptions;
import software.amazon.awssdk.services.ec2.model.ClientLoginBannerOptions;
import software.amazon.awssdk.services.ec2.model.ClientRouteEnforcementOptions;
import software.amazon.awssdk.services.ec2.model.ClientVpnSecurityGroupIdSetCopier;
import software.amazon.awssdk.services.ec2.model.ConnectionLogOptions;
import software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SelfServicePortal;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClientVpnEndpointRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::clientVpnEndpointId)).setter(ModifyClientVpnEndpointRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerCertificateArn").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::serverCertificateArn)).setter(ModifyClientVpnEndpointRequest.setter(Builder::serverCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").unmarshallLocationName("ServerCertificateArn").build()}).build();
    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionLogOptions").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::connectionLogOptions)).setter(ModifyClientVpnEndpointRequest.setter(Builder::connectionLogOptions)).constructor(ConnectionLogOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").unmarshallLocationName("ConnectionLogOptions").build()}).build();
    private static final SdkField<DnsServersOptionsModifyStructure> DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsServers").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::dnsServers)).setter(ModifyClientVpnEndpointRequest.setter(Builder::dnsServers)).constructor(DnsServersOptionsModifyStructure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers").unmarshallLocationName("DnsServers").build()}).build();
    private static final SdkField<Integer> VPN_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VpnPort").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::vpnPort)).setter(ModifyClientVpnEndpointRequest.setter(Builder::vpnPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPort").unmarshallLocationName("VpnPort").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::description)).setter(ModifyClientVpnEndpointRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SplitTunnel").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::splitTunnel)).setter(ModifyClientVpnEndpointRequest.setter(Builder::splitTunnel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel").unmarshallLocationName("SplitTunnel").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::dryRun)).setter(ModifyClientVpnEndpointRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::securityGroupIds)).setter(ModifyClientVpnEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::vpcId)).setter(ModifyClientVpnEndpointRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build();
    private static final SdkField<String> SELF_SERVICE_PORTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelfServicePortal").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::selfServicePortalAsString)).setter(ModifyClientVpnEndpointRequest.setter(Builder::selfServicePortal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServicePortal").unmarshallLocationName("SelfServicePortal").build()}).build();
    private static final SdkField<ClientConnectOptions> CLIENT_CONNECT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientConnectOptions").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::clientConnectOptions)).setter(ModifyClientVpnEndpointRequest.setter(Builder::clientConnectOptions)).constructor(ClientConnectOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConnectOptions").unmarshallLocationName("ClientConnectOptions").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionTimeoutHours").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::sessionTimeoutHours)).setter(ModifyClientVpnEndpointRequest.setter(Builder::sessionTimeoutHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutHours").unmarshallLocationName("SessionTimeoutHours").build()}).build();
    private static final SdkField<ClientLoginBannerOptions> CLIENT_LOGIN_BANNER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientLoginBannerOptions").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::clientLoginBannerOptions)).setter(ModifyClientVpnEndpointRequest.setter(Builder::clientLoginBannerOptions)).constructor(ClientLoginBannerOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLoginBannerOptions").unmarshallLocationName("ClientLoginBannerOptions").build()}).build();
    private static final SdkField<ClientRouteEnforcementOptions> CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientRouteEnforcementOptions").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::clientRouteEnforcementOptions)).setter(ModifyClientVpnEndpointRequest.setter(Builder::clientRouteEnforcementOptions)).constructor(ClientRouteEnforcementOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRouteEnforcementOptions").unmarshallLocationName("ClientRouteEnforcementOptions").build()}).build();
    private static final SdkField<Boolean> DISCONNECT_ON_SESSION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisconnectOnSessionTimeout").getter(ModifyClientVpnEndpointRequest.getter(ModifyClientVpnEndpointRequest::disconnectOnSessionTimeout)).setter(ModifyClientVpnEndpointRequest.setter(Builder::disconnectOnSessionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectOnSessionTimeout").unmarshallLocationName("DisconnectOnSessionTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, SERVER_CERTIFICATE_ARN_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD, VPN_PORT_FIELD, DESCRIPTION_FIELD, SPLIT_TUNNEL_FIELD, DRY_RUN_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ID_FIELD, SELF_SERVICE_PORTAL_FIELD, CLIENT_CONNECT_OPTIONS_FIELD, SESSION_TIMEOUT_HOURS_FIELD, CLIENT_LOGIN_BANNER_OPTIONS_FIELD, CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD, DISCONNECT_ON_SESSION_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyClientVpnEndpointRequest.memberNameToFieldInitializer();
    private final String clientVpnEndpointId;
    private final String serverCertificateArn;
    private final ConnectionLogOptions connectionLogOptions;
    private final DnsServersOptionsModifyStructure dnsServers;
    private final Integer vpnPort;
    private final String description;
    private final Boolean splitTunnel;
    private final Boolean dryRun;
    private final List<String> securityGroupIds;
    private final String vpcId;
    private final String selfServicePortal;
    private final ClientConnectOptions clientConnectOptions;
    private final Integer sessionTimeoutHours;
    private final ClientLoginBannerOptions clientLoginBannerOptions;
    private final ClientRouteEnforcementOptions clientRouteEnforcementOptions;
    private final Boolean disconnectOnSessionTimeout;

    private ModifyClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.vpnPort = builder.vpnPort;
        this.description = builder.description;
        this.splitTunnel = builder.splitTunnel;
        this.dryRun = builder.dryRun;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
        this.selfServicePortal = builder.selfServicePortal;
        this.clientConnectOptions = builder.clientConnectOptions;
        this.sessionTimeoutHours = builder.sessionTimeoutHours;
        this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
        this.clientRouteEnforcementOptions = builder.clientRouteEnforcementOptions;
        this.disconnectOnSessionTimeout = builder.disconnectOnSessionTimeout;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public final ConnectionLogOptions connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public final DnsServersOptionsModifyStructure dnsServers() {
        return this.dnsServers;
    }

    public final Integer vpnPort() {
        return this.vpnPort;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean splitTunnel() {
        return this.splitTunnel;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final SelfServicePortal selfServicePortal() {
        return SelfServicePortal.fromValue(this.selfServicePortal);
    }

    public final String selfServicePortalAsString() {
        return this.selfServicePortal;
    }

    public final ClientConnectOptions clientConnectOptions() {
        return this.clientConnectOptions;
    }

    public final Integer sessionTimeoutHours() {
        return this.sessionTimeoutHours;
    }

    public final ClientLoginBannerOptions clientLoginBannerOptions() {
        return this.clientLoginBannerOptions;
    }

    public final ClientRouteEnforcementOptions clientRouteEnforcementOptions() {
        return this.clientRouteEnforcementOptions;
    }

    public final Boolean disconnectOnSessionTimeout() {
        return this.disconnectOnSessionTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServicePortalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientConnectOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientLoginBannerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRouteEnforcementOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectOnSessionTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClientVpnEndpointRequest)) {
            return false;
        }
        ModifyClientVpnEndpointRequest other = (ModifyClientVpnEndpointRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.serverCertificateArn(), other.serverCertificateArn()) && Objects.equals(this.connectionLogOptions(), other.connectionLogOptions()) && Objects.equals(this.dnsServers(), other.dnsServers()) && Objects.equals(this.vpnPort(), other.vpnPort()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.splitTunnel(), other.splitTunnel()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.selfServicePortalAsString(), other.selfServicePortalAsString()) && Objects.equals(this.clientConnectOptions(), other.clientConnectOptions()) && Objects.equals(this.sessionTimeoutHours(), other.sessionTimeoutHours()) && Objects.equals(this.clientLoginBannerOptions(), other.clientLoginBannerOptions()) && Objects.equals(this.clientRouteEnforcementOptions(), other.clientRouteEnforcementOptions()) && Objects.equals(this.disconnectOnSessionTimeout(), other.disconnectOnSessionTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyClientVpnEndpointRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("ServerCertificateArn", (Object)this.serverCertificateArn()).add("ConnectionLogOptions", (Object)this.connectionLogOptions()).add("DnsServers", (Object)this.dnsServers()).add("VpnPort", (Object)this.vpnPort()).add("Description", (Object)this.description()).add("SplitTunnel", (Object)this.splitTunnel()).add("DryRun", (Object)this.dryRun()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("VpcId", (Object)this.vpcId()).add("SelfServicePortal", (Object)this.selfServicePortalAsString()).add("ClientConnectOptions", (Object)this.clientConnectOptions()).add("SessionTimeoutHours", (Object)this.sessionTimeoutHours()).add("ClientLoginBannerOptions", (Object)this.clientLoginBannerOptions()).add("ClientRouteEnforcementOptions", (Object)this.clientRouteEnforcementOptions()).add("DisconnectOnSessionTimeout", (Object)this.disconnectOnSessionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "ServerCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArn()));
            }
            case "ConnectionLogOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionLogOptions()));
            }
            case "DnsServers": {
                return Optional.ofNullable(clazz.cast(this.dnsServers()));
            }
            case "VpnPort": {
                return Optional.ofNullable(clazz.cast(this.vpnPort()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SplitTunnel": {
                return Optional.ofNullable(clazz.cast(this.splitTunnel()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SelfServicePortal": {
                return Optional.ofNullable(clazz.cast(this.selfServicePortalAsString()));
            }
            case "ClientConnectOptions": {
                return Optional.ofNullable(clazz.cast(this.clientConnectOptions()));
            }
            case "SessionTimeoutHours": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutHours()));
            }
            case "ClientLoginBannerOptions": {
                return Optional.ofNullable(clazz.cast(this.clientLoginBannerOptions()));
            }
            case "ClientRouteEnforcementOptions": {
                return Optional.ofNullable(clazz.cast(this.clientRouteEnforcementOptions()));
            }
            case "DisconnectOnSessionTimeout": {
                return Optional.ofNullable(clazz.cast(this.disconnectOnSessionTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
        map.put("ServerCertificateArn", SERVER_CERTIFICATE_ARN_FIELD);
        map.put("ConnectionLogOptions", CONNECTION_LOG_OPTIONS_FIELD);
        map.put("DnsServers", DNS_SERVERS_FIELD);
        map.put("VpnPort", VPN_PORT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SplitTunnel", SPLIT_TUNNEL_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_IDS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SelfServicePortal", SELF_SERVICE_PORTAL_FIELD);
        map.put("ClientConnectOptions", CLIENT_CONNECT_OPTIONS_FIELD);
        map.put("SessionTimeoutHours", SESSION_TIMEOUT_HOURS_FIELD);
        map.put("ClientLoginBannerOptions", CLIENT_LOGIN_BANNER_OPTIONS_FIELD);
        map.put("ClientRouteEnforcementOptions", CLIENT_ROUTE_ENFORCEMENT_OPTIONS_FIELD);
        map.put("DisconnectOnSessionTimeout", DISCONNECT_ON_SESSION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((ModifyClientVpnEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String serverCertificateArn;
        private ConnectionLogOptions connectionLogOptions;
        private DnsServersOptionsModifyStructure dnsServers;
        private Integer vpnPort;
        private String description;
        private Boolean splitTunnel;
        private Boolean dryRun;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String selfServicePortal;
        private ClientConnectOptions clientConnectOptions;
        private Integer sessionTimeoutHours;
        private ClientLoginBannerOptions clientLoginBannerOptions;
        private ClientRouteEnforcementOptions clientRouteEnforcementOptions;
        private Boolean disconnectOnSessionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClientVpnEndpointRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.serverCertificateArn(model.serverCertificateArn);
            this.connectionLogOptions(model.connectionLogOptions);
            this.dnsServers(model.dnsServers);
            this.vpnPort(model.vpnPort);
            this.description(model.description);
            this.splitTunnel(model.splitTunnel);
            this.dryRun(model.dryRun);
            this.securityGroupIds(model.securityGroupIds);
            this.vpcId(model.vpcId);
            this.selfServicePortal(model.selfServicePortal);
            this.clientConnectOptions(model.clientConnectOptions);
            this.sessionTimeoutHours(model.sessionTimeoutHours);
            this.clientLoginBannerOptions(model.clientLoginBannerOptions);
            this.clientRouteEnforcementOptions(model.clientRouteEnforcementOptions);
            this.disconnectOnSessionTimeout(model.disconnectOnSessionTimeout);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return this.connectionLogOptions != null ? this.connectionLogOptions.toBuilder() : null;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final DnsServersOptionsModifyStructure.Builder getDnsServers() {
            return this.dnsServers != null ? this.dnsServers.toBuilder() : null;
        }

        public final void setDnsServers(DnsServersOptionsModifyStructure.BuilderImpl dnsServers) {
            this.dnsServers = dnsServers != null ? dnsServers.build() : null;
        }

        @Override
        public final Builder dnsServers(DnsServersOptionsModifyStructure dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public final Integer getVpnPort() {
            return this.vpnPort;
        }

        public final void setVpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
        }

        @Override
        public final Builder vpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getSplitTunnel() {
            return this.splitTunnel;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ClientVpnSecurityGroupIdSetCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSelfServicePortal() {
            return this.selfServicePortal;
        }

        public final void setSelfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
        }

        @Override
        public final Builder selfServicePortal(String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        @Override
        public final Builder selfServicePortal(SelfServicePortal selfServicePortal) {
            this.selfServicePortal(selfServicePortal == null ? null : selfServicePortal.toString());
            return this;
        }

        public final ClientConnectOptions.Builder getClientConnectOptions() {
            return this.clientConnectOptions != null ? this.clientConnectOptions.toBuilder() : null;
        }

        public final void setClientConnectOptions(ClientConnectOptions.BuilderImpl clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions != null ? clientConnectOptions.build() : null;
        }

        @Override
        public final Builder clientConnectOptions(ClientConnectOptions clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public final Integer getSessionTimeoutHours() {
            return this.sessionTimeoutHours;
        }

        public final void setSessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
        }

        @Override
        public final Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public final ClientLoginBannerOptions.Builder getClientLoginBannerOptions() {
            return this.clientLoginBannerOptions != null ? this.clientLoginBannerOptions.toBuilder() : null;
        }

        public final void setClientLoginBannerOptions(ClientLoginBannerOptions.BuilderImpl clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions != null ? clientLoginBannerOptions.build() : null;
        }

        @Override
        public final Builder clientLoginBannerOptions(ClientLoginBannerOptions clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        public final ClientRouteEnforcementOptions.Builder getClientRouteEnforcementOptions() {
            return this.clientRouteEnforcementOptions != null ? this.clientRouteEnforcementOptions.toBuilder() : null;
        }

        public final void setClientRouteEnforcementOptions(ClientRouteEnforcementOptions.BuilderImpl clientRouteEnforcementOptions) {
            this.clientRouteEnforcementOptions = clientRouteEnforcementOptions != null ? clientRouteEnforcementOptions.build() : null;
        }

        @Override
        public final Builder clientRouteEnforcementOptions(ClientRouteEnforcementOptions clientRouteEnforcementOptions) {
            this.clientRouteEnforcementOptions = clientRouteEnforcementOptions;
            return this;
        }

        public final Boolean getDisconnectOnSessionTimeout() {
            return this.disconnectOnSessionTimeout;
        }

        public final void setDisconnectOnSessionTimeout(Boolean disconnectOnSessionTimeout) {
            this.disconnectOnSessionTimeout = disconnectOnSessionTimeout;
        }

        @Override
        public final Builder disconnectOnSessionTimeout(Boolean disconnectOnSessionTimeout) {
            this.disconnectOnSessionTimeout = disconnectOnSessionTimeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClientVpnEndpointRequest build() {
            return new ModifyClientVpnEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClientVpnEndpointRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder serverCertificateArn(String var1);

        public Builder connectionLogOptions(ConnectionLogOptions var1);

        default public Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return this.connectionLogOptions((ConnectionLogOptions)((ConnectionLogOptions.Builder)ConnectionLogOptions.builder().applyMutation(connectionLogOptions)).build());
        }

        public Builder dnsServers(DnsServersOptionsModifyStructure var1);

        default public Builder dnsServers(Consumer<DnsServersOptionsModifyStructure.Builder> dnsServers) {
            return this.dnsServers((DnsServersOptionsModifyStructure)((DnsServersOptionsModifyStructure.Builder)DnsServersOptionsModifyStructure.builder().applyMutation(dnsServers)).build());
        }

        public Builder vpnPort(Integer var1);

        public Builder description(String var1);

        public Builder splitTunnel(Boolean var1);

        public Builder dryRun(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder vpcId(String var1);

        public Builder selfServicePortal(String var1);

        public Builder selfServicePortal(SelfServicePortal var1);

        public Builder clientConnectOptions(ClientConnectOptions var1);

        default public Builder clientConnectOptions(Consumer<ClientConnectOptions.Builder> clientConnectOptions) {
            return this.clientConnectOptions((ClientConnectOptions)((ClientConnectOptions.Builder)ClientConnectOptions.builder().applyMutation(clientConnectOptions)).build());
        }

        public Builder sessionTimeoutHours(Integer var1);

        public Builder clientLoginBannerOptions(ClientLoginBannerOptions var1);

        default public Builder clientLoginBannerOptions(Consumer<ClientLoginBannerOptions.Builder> clientLoginBannerOptions) {
            return this.clientLoginBannerOptions((ClientLoginBannerOptions)((ClientLoginBannerOptions.Builder)ClientLoginBannerOptions.builder().applyMutation(clientLoginBannerOptions)).build());
        }

        public Builder clientRouteEnforcementOptions(ClientRouteEnforcementOptions var1);

        default public Builder clientRouteEnforcementOptions(Consumer<ClientRouteEnforcementOptions.Builder> clientRouteEnforcementOptions) {
            return this.clientRouteEnforcementOptions((ClientRouteEnforcementOptions)((ClientRouteEnforcementOptions.Builder)ClientRouteEnforcementOptions.builder().applyMutation(clientRouteEnforcementOptions)).build());
        }

        public Builder disconnectOnSessionTimeout(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

