/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReservedInstanceState {
    PAYMENT_PENDING("payment-pending"),
    ACTIVE("active"),
    PAYMENT_FAILED("payment-failed"),
    RETIRED("retired"),
    QUEUED("queued"),
    QUEUED_DELETED("queued-deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReservedInstanceState> VALUE_MAP;
    private final String value;

    private ReservedInstanceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReservedInstanceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReservedInstanceState> knownValues() {
        EnumSet<ReservedInstanceState> knownValues = EnumSet.allOf(ReservedInstanceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReservedInstanceState.class, ReservedInstanceState::toString);
    }
}

