/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribePublicIpv4PoolsResponse;
import software.amazon.awssdk.services.ec2.model.PublicIpv4Pool;

public class DescribePublicIpv4PoolsPublisher
implements SdkPublisher<DescribePublicIpv4PoolsResponse> {
    private final Ec2AsyncClient client;
    private final DescribePublicIpv4PoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePublicIpv4PoolsPublisher(Ec2AsyncClient client, DescribePublicIpv4PoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePublicIpv4PoolsPublisher(Ec2AsyncClient client, DescribePublicIpv4PoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePublicIpv4PoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePublicIpv4PoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PublicIpv4Pool> publicIpv4Pools() {
        Function<DescribePublicIpv4PoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicIpv4Pools() != null) {
                return response.publicIpv4Pools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePublicIpv4PoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePublicIpv4PoolsResponseFetcher
    implements AsyncPageFetcher<DescribePublicIpv4PoolsResponse> {
        private DescribePublicIpv4PoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePublicIpv4PoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePublicIpv4PoolsResponse> nextPage(DescribePublicIpv4PoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribePublicIpv4PoolsPublisher.this.client.describePublicIpv4Pools(DescribePublicIpv4PoolsPublisher.this.firstRequest);
            }
            return DescribePublicIpv4PoolsPublisher.this.client.describePublicIpv4Pools((DescribePublicIpv4PoolsRequest)((Object)DescribePublicIpv4PoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

