/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesResponse;
import software.amazon.awssdk.services.ec2.model.PrefixListEntry;

public class GetManagedPrefixListEntriesIterable
implements SdkIterable<GetManagedPrefixListEntriesResponse> {
    private final Ec2Client client;
    private final GetManagedPrefixListEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetManagedPrefixListEntriesIterable(Ec2Client client, GetManagedPrefixListEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetManagedPrefixListEntriesResponseFetcher();
    }

    public Iterator<GetManagedPrefixListEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrefixListEntry> entries() {
        Function<GetManagedPrefixListEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetManagedPrefixListEntriesResponseFetcher
    implements SyncPageFetcher<GetManagedPrefixListEntriesResponse> {
        private GetManagedPrefixListEntriesResponseFetcher() {
        }

        public boolean hasNextPage(GetManagedPrefixListEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetManagedPrefixListEntriesResponse nextPage(GetManagedPrefixListEntriesResponse previousPage) {
            if (previousPage == null) {
                return GetManagedPrefixListEntriesIterable.this.client.getManagedPrefixListEntries(GetManagedPrefixListEntriesIterable.this.firstRequest);
            }
            return GetManagedPrefixListEntriesIterable.this.client.getManagedPrefixListEntries((GetManagedPrefixListEntriesRequest)((Object)GetManagedPrefixListEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

