/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.functors.FunctorUtils;
import org.apache.commons.collections4.functors.NOPClosure;

public class ChainedClosure<T>
implements Closure<T>,
Serializable {
    private static final long serialVersionUID = -3520677225766901240L;
    private final Closure<? super T>[] iClosures;

    public static <E> Closure<E> chainedClosure(Closure<? super E> ... closures) {
        FunctorUtils.validate(closures);
        if (closures.length == 0) {
            return NOPClosure.nopClosure();
        }
        return new ChainedClosure<E>(closures);
    }

    public static <E> Closure<E> chainedClosure(Collection<? extends Closure<? super E>> closures) {
        Objects.requireNonNull(closures, "closures");
        if (closures.isEmpty()) {
            return NOPClosure.nopClosure();
        }
        Closure[] cmds = new Closure[closures.size()];
        int i = 0;
        for (Closure<E> closure : closures) {
            cmds[i++] = closure;
        }
        FunctorUtils.validate(cmds);
        return new ChainedClosure(false, cmds);
    }

    private ChainedClosure(boolean clone, Closure<? super T> ... closures) {
        this.iClosures = clone ? (Closure[])FunctorUtils.copy((Consumer[])closures) : closures;
    }

    public ChainedClosure(Closure<? super T> ... closures) {
        this(true, closures);
    }

    @Override
    public void execute(T input) {
        for (Closure<T> closure : this.iClosures) {
            closure.accept(input);
        }
    }

    public Closure<? super T>[] getClosures() {
        return (Closure[])FunctorUtils.copy((Consumer[])this.iClosures);
    }
}

