/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.KNN9120Codec;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;

public class KNN9120BinaryVectorScorer
implements FlatVectorsScorer {
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues) throws IOException {
        if (randomAccessVectorValues instanceof ByteVectorValues) {
            return new BinaryRandomVectorScorerSupplier((ByteVectorValues)randomAccessVectorValues);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues, float[] queryVector) throws IOException {
        throw new IllegalArgumentException("binary vectors do not support float[] targets");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction vectorSimilarityFunction, KnnVectorValues randomAccessVectorValues, byte[] queryVector) throws IOException {
        if (randomAccessVectorValues instanceof ByteVectorValues) {
            return new BinaryRandomVectorScorer((ByteVectorValues)randomAccessVectorValues, queryVector);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    static class BinaryRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        protected final ByteVectorValues vectorValues;
        protected final ByteVectorValues targetVectors;

        public BinaryRandomVectorScorerSupplier(ByteVectorValues vectorValues) throws IOException {
            this.vectorValues = vectorValues;
            this.targetVectors = vectorValues.copy();
        }

        public UpdateableRandomVectorScorer scorer() throws IOException {
            byte[] query = new byte[this.vectorValues.dimension()];
            return new BinaryRandomVectorScorer(this.vectorValues, query);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return new BinaryRandomVectorScorerSupplier(this.vectorValues.copy());
        }
    }

    static class BinaryRandomVectorScorer
    implements UpdateableRandomVectorScorer {
        private final ByteVectorValues vectorValues;
        private final byte[] queryVector;

        BinaryRandomVectorScorer(ByteVectorValues vectorValues, byte[] query) {
            this.queryVector = query;
            this.vectorValues = vectorValues;
        }

        public float score(int node) throws IOException {
            return KNNVectorSimilarityFunction.HAMMING.compare(this.queryVector, this.vectorValues.vectorValue(node));
        }

        public int maxOrd() {
            return this.vectorValues.size();
        }

        public int ordToDoc(int ord) {
            return this.vectorValues.ordToDoc(ord);
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.vectorValues.getAcceptOrds(acceptDocs);
        }

        public void setScoringOrdinal(int node) throws IOException {
            System.arraycopy(this.vectorValues.vectorValue(node), 0, this.queryVector, 0, this.queryVector.length);
        }
    }
}

