/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class WildcardQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, WildcardQuery> {
    @Nullable
    private final Boolean caseInsensitive;
    @Nonnull
    private final String field;
    @Nullable
    private final String rewrite;
    @Nullable
    private final String value;
    @Nullable
    private final String wildcard;
    public static final JsonpDeserializer<WildcardQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardQuery::setupWildcardQueryDeserializer);

    private WildcardQuery(Builder builder) {
        super(builder);
        this.caseInsensitive = builder.caseInsensitive;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.rewrite = builder.rewrite;
        this.value = builder.value;
        this.wildcard = builder.wildcard;
    }

    public static WildcardQuery of(Function<Builder, ObjectBuilder<WildcardQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Wildcard;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    @Nullable
    public final String value() {
        return this.value;
    }

    @Nullable
    public final String wildcard() {
        return this.wildcard;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value);
        }
        if (this.wildcard != null) {
            generator.writeKey("wildcard");
            generator.write(this.wildcard);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupWildcardQueryDeserializer(ObjectDeserializer<Builder> op) {
        WildcardQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.add(Builder::wildcard, JsonpDeserializer.stringDeserializer(), "wildcard");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.caseInsensitive);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.rewrite);
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.wildcard);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardQuery other = (WildcardQuery)o;
        return Objects.equals(this.caseInsensitive, other.caseInsensitive) && this.field.equals(other.field) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.value, other.value) && Objects.equals(this.wildcard, other.wildcard);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, WildcardQuery> {
        @Nullable
        private Boolean caseInsensitive;
        private String field;
        @Nullable
        private String rewrite;
        @Nullable
        private String value;
        @Nullable
        private String wildcard;

        public Builder() {
        }

        private Builder(WildcardQuery o) {
            super(o);
            this.caseInsensitive = o.caseInsensitive;
            this.field = o.field;
            this.rewrite = o.rewrite;
            this.value = o.value;
            this.wildcard = o.wildcard;
        }

        private Builder(Builder o) {
            super(o);
            this.caseInsensitive = o.caseInsensitive;
            this.field = o.field;
            this.rewrite = o.rewrite;
            this.value = o.value;
            this.wildcard = o.wildcard;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder wildcard(@Nullable String value) {
            this.wildcard = value;
            return this;
        }

        @Override
        @Nonnull
        public WildcardQuery build() {
            this._checkSingleUse();
            return new WildcardQuery(this);
        }
    }
}

