/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NestedIdentity
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NestedIdentity> {
    @Nonnull
    private final String field;
    @Nullable
    private final NestedIdentity nested;
    private final int offset;
    public static final JsonpDeserializer<NestedIdentity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedIdentity::setupNestedIdentityDeserializer);

    private NestedIdentity(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.nested = builder.nested;
        this.offset = ApiTypeHelper.requireNonNull(builder.offset, this, "offset");
    }

    public static NestedIdentity of(Function<Builder, ObjectBuilder<NestedIdentity>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final NestedIdentity nested() {
        return this.nested;
    }

    public final int offset() {
        return this.offset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
        generator.writeKey("offset");
        generator.write(this.offset);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNestedIdentityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::nested, _DESERIALIZER, "_nested");
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.nested);
        result = 31 * result + Integer.hashCode(this.offset);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedIdentity other = (NestedIdentity)o;
        return this.field.equals(other.field) && Objects.equals(this.nested, other.nested) && this.offset == other.offset;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NestedIdentity> {
        private String field;
        @Nullable
        private NestedIdentity nested;
        private Integer offset;

        public Builder() {
        }

        private Builder(NestedIdentity o) {
            this.field = o.field;
            this.nested = o.nested;
            this.offset = o.offset;
        }

        private Builder(Builder o) {
            this.field = o.field;
            this.nested = o.nested;
            this.offset = o.offset;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        @Nonnull
        public final Builder nested(Function<Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new Builder()).build());
        }

        @Nonnull
        public final Builder offset(int value) {
            this.offset = value;
            return this;
        }

        @Override
        @Nonnull
        public NestedIdentity build() {
            this._checkSingleUse();
            return new NestedIdentity(this);
        }
    }
}

