/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opensearch.client.util.ApiTypeHelper;

public class ObjectBuilderBase {
    private boolean _used = false;

    protected void _checkSingleUse() {
        if (this._used) {
            throw new IllegalStateException("Object builders can only be used once");
        }
        this._used = true;
    }

    private static <T> List<T> _mutableList(List<T> list) {
        if (!ApiTypeHelper.isDefined(list)) {
            return new InternalList();
        }
        if (list instanceof InternalList) {
            return list;
        }
        return new InternalList<T>(list);
    }

    @Nullable
    protected static <T> List<T> _listCopy(@Nullable List<T> list) {
        return ApiTypeHelper.isDefined(list) ? new InternalList<T>(list) : null;
    }

    @SafeVarargs
    protected static <T> List<T> _listAdd(List<T> list, T value, T ... values) {
        list = ObjectBuilderBase._mutableList(list);
        list.add(value);
        if (values.length > 0) {
            list.addAll(Arrays.asList(values));
        }
        return list;
    }

    protected static <T> List<T> _listAddAll(List<T> list, List<T> values) {
        if (list == null) {
            return Objects.requireNonNull(values);
        }
        list = ObjectBuilderBase._mutableList(list);
        list.addAll(values);
        return list;
    }

    private static <K, V> Map<K, V> _mutableMap(Map<K, V> map) {
        if (!ApiTypeHelper.isDefined(map)) {
            return new InternalMap();
        }
        if (map instanceof InternalMap) {
            return map;
        }
        return new InternalMap<K, V>(map);
    }

    @Nullable
    protected static <K, V> Map<K, V> _mapCopy(@Nullable Map<K, V> map) {
        return ApiTypeHelper.isDefined(map) ? new InternalMap<K, V>(map) : null;
    }

    protected static <K, V> Map<K, V> _mapPut(Map<K, V> map, K key, V value) {
        map = ObjectBuilderBase._mutableMap(map);
        map.put(key, value);
        return map;
    }

    protected static <K, V> Map<K, V> _mapPutAll(Map<K, V> map, Map<K, V> entries) {
        if (map == null) {
            return Objects.requireNonNull(entries);
        }
        map = ObjectBuilderBase._mutableMap(map);
        map.putAll(entries);
        return map;
    }

    static final class InternalList<T>
    extends ArrayList<T> {
        InternalList() {
        }

        InternalList(Collection<? extends T> c) {
            super(c);
        }
    }

    private static final class InternalMap<K, V>
    extends HashMap<K, V> {
        InternalMap() {
        }

        InternalMap(Map<? extends K, ? extends V> m) {
            super(m);
        }
    }
}

