/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.crypto.fips.DSAOutputSigner;
import org.bouncycastle.crypto.fips.DSAOutputValidator;
import org.bouncycastle.crypto.fips.DSAOutputVerifier;
import org.bouncycastle.crypto.fips.EcDHAgreement;
import org.bouncycastle.crypto.fips.EcDHUAgreement;
import org.bouncycastle.crypto.fips.EcDhBasicAgreement;
import org.bouncycastle.crypto.fips.EcDhcBasicAgreement;
import org.bouncycastle.crypto.fips.EcDhcuBasicAgreement;
import org.bouncycastle.crypto.fips.EcDsaSigner;
import org.bouncycastle.crypto.fips.EcKeyGenerationParameters;
import org.bouncycastle.crypto.fips.EcKeyPairGenerator;
import org.bouncycastle.crypto.fips.EcMqvBasicAgreement;
import org.bouncycastle.crypto.fips.FipsAgreement;
import org.bouncycastle.crypto.fips.FipsAgreementFactory;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsOutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.fips.FipsOutputValidator;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsSignatureOperatorFactory;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.HMacDsaKCalculator;
import org.bouncycastle.crypto.fips.NullDigest;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.crypto.internal.params.EcDhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcDhuPublicParameters;
import org.bouncycastle.crypto.internal.params.EcDomainParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPrivateParameters;
import org.bouncycastle.crypto.internal.params.EcMqvPublicParameters;
import org.bouncycastle.crypto.internal.params.EcNamedDomainParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.test.ConsistencyTest;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.TestRandomBigInteger;
import org.bouncycastle.util.test.TestRandomData;

public final class FipsEC {
    private static final Logger LOG = Logger.getLogger(FipsEC.class.getName());
    private static final int MIN_FIPS_FIELD_SIZE = 224;
    private static final BigInteger TEST_D_OFFSET = new BigInteger("deadbeef", 16);
    private static final AsymmetricCipherKeyPair katKeyPair = FipsEC.getKATKeyPair();
    private static final AsymmetricCipherKeyPair f2mKatKeyPair = FipsEC.getF2mKATKeyPair();
    public static final FipsAlgorithm ALGORITHM = new FipsAlgorithm("EC");
    private static final FipsAlgorithm ALGORITHM_MQV = new FipsAlgorithm("ECMQV", (Enum)Variations.ECMQV);
    private static final FipsAlgorithm ALGORITHM_DHU = new FipsAlgorithm("ECCDHU", (Enum)Variations.ECCDHU);
    public static final DSAParameters DSA = new DSAParameters(new FipsAlgorithm("ECDSA", (Enum)Variations.ECDSA), FipsSHS.Algorithm.SHA1);
    public static final DSAParameters DDSA = new DSAParameters(new FipsAlgorithm(ALGORITHM.getName(), (Enum)Variations.ECDDSA), FipsSHS.Algorithm.SHA1);
    public static final AgreementParameters DH = new AgreementParameters(new FipsAlgorithm("ECDH", (Enum)Variations.ECDH));
    public static final AgreementParameters CDH = new AgreementParameters(new FipsAlgorithm("ECCDH", (Enum)Variations.ECCDH));
    public static final MQVAgreementParametersBuilder MQV = new MQVAgreementParametersBuilder();
    public static final DHUAgreementParametersBuilder CDHU = new DHUAgreementParametersBuilder();
    private static final DsaProvider DSA_PROVIDER = new DsaProvider();
    private static final FipsEngineProvider<EcDhBasicAgreement> DH_PROVIDER = new DhProvider();
    private static final FipsEngineProvider<EcDhcBasicAgreement> CDH_PROVIDER = new DhcProvider();
    private static final FipsEngineProvider<EcMqvBasicAgreement> MQV_PROVIDER = new MqvProvider();
    private static final FipsEngineProvider<EcDhcuBasicAgreement> DHU_PROVIDER = new DhuProvider();
    private static Set<ASN1ObjectIdentifier> approvedKeySet;

    private FipsEC() {
    }

    private static void validateDomainParameters(ECDomainParameters eCDomainParameters) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCDomainParameters instanceof NamedECDomainParameters ? ((NamedECDomainParameters)eCDomainParameters).getID() : ECDomainParametersIndex.lookupOID(eCDomainParameters);
        if (aSN1ObjectIdentifier == null || !approvedKeySet.contains(aSN1ObjectIdentifier)) {
            throw new FipsUnapprovedOperationError("EC domain parameters not on approved list");
        }
    }

    private static void checkEnabled() {
        if (Properties.isOverrideSet("org.bouncycastle.ec.disable")) {
            throw new UnsupportedOperationException("EC has been disabled by setting \"org.bouncycastle.ec.disable\"");
        }
    }

    private static void validateKeyPair(FipsAlgorithm fipsAlgorithm, AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        Variations variations = fipsAlgorithm == ALGORITHM ? Variations.ECDSA : (Variations)fipsAlgorithm.basicVariation();
        switch (variations) {
            case ECDSA: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDsaSigner ecDsaSigner = new EcDsaSigner();
                        ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                        byte[] byArray = new byte[32];
                        byArray[1] = 1;
                        BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                        ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                        return ecDsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                    }
                });
                break;
            }
            case ECDH: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhBasicAgreement ecDhBasicAgreement = new EcDhBasicAgreement();
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case ECCDH: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhcBasicAgreement ecDhcBasicAgreement = new EcDhcBasicAgreement();
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger2 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                        BigInteger bigInteger3 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic());
                        ecDhcBasicAgreement.init(asymmetricCipherKeyPair2.getPrivate());
                        BigInteger bigInteger4 = ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair.getPublic());
                        return !bigInteger.equals(bigInteger2) && !bigInteger.equals(bigInteger3) && bigInteger3.equals(bigInteger4);
                    }
                });
                break;
            }
            case ECMQV: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcMqvBasicAgreement ecMqvBasicAgreement = new EcMqvBasicAgreement();
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        BigInteger bigInteger2 = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        BigInteger bigInteger3 = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !bigInteger.equals(bigInteger2) && bigInteger2.equals(bigInteger3);
                    }
                });
                break;
            }
            case ECCDHU: {
                SelfTestExecutor.validate(fipsAlgorithm, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

                    @Override
                    public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) throws Exception {
                        EcDhcuBasicAgreement ecDhcuBasicAgreement = new EcDhcuBasicAgreement();
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                        byte[] byArray2 = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                        ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair2.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair3.getPrivate()));
                        byte[] byArray3 = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic()));
                        return !Arrays.areEqual(byArray, byArray2) && Arrays.areEqual(byArray2, byArray3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled EC algorithm: " + fipsAlgorithm.getName());
            }
        }
    }

    private static AsymmetricCipherKeyPair getKATKeyPair() {
        NamedECDomainParameters namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters(SECObjectIdentifiers.secp256r1);
        EcDomainParameters ecDomainParameters = new EcDomainParameters(new ECDomainParameters(namedECDomainParameters.getCurve(), namedECDomainParameters.getG(), namedECDomainParameters.getN(), namedECDomainParameters.getH(), namedECDomainParameters.getSeed()));
        EcPrivateKeyParameters ecPrivateKeyParameters = new EcPrivateKeyParameters(new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008"), ecDomainParameters);
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(ecDomainParameters.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D")), ecDomainParameters);
        return new AsymmetricCipherKeyPair(ecPublicKeyParameters, ecPrivateKeyParameters);
    }

    private static AsymmetricCipherKeyPair getF2mKATKeyPair() {
        X9ECParameters x9ECParameters = NISTNamedCurves.getByName("B-233");
        EcDomainParameters ecDomainParameters = new EcDomainParameters(new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
        EcPrivateKeyParameters ecPrivateKeyParameters = new EcPrivateKeyParameters(new BigInteger("20186677036482506115567393538695075300175221296989956723148347484984008"), ecDomainParameters);
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(ecDomainParameters.getCurve().decodePoint(Hex.decode("03000518bce3b1b492c23094dcd7674c8ea6a3bcb7861bd2fb11be1999b796")), ecDomainParameters);
        return new AsymmetricCipherKeyPair(ecPublicKeyParameters, ecPrivateKeyParameters);
    }

    private static void f2mDsaTest(EcDsaSigner ecDsaSigner) {
        SelfTestExecutor.validate(ALGORITHM, ecDsaSigner, new VariantKatTest<EcDsaSigner>(){

            @Override
            void evaluate(EcDsaSigner ecDsaSigner) throws Exception {
                BigInteger bigInteger = new BigInteger(1, Hex.decode("d001312179360f7a557d4686e2faf9740fd3289edbafb5e551402cf1b0"));
                BigInteger bigInteger2 = new BigInteger(1, Hex.decode("9d4c2f24b50ce6b9ac725c7833c495fe703296c038dab05ea7af06cafe"));
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = f2mKatKeyPair;
                TestRandomBigInteger testRandomBigInteger = new TestRandomBigInteger(233, Hex.decode("640d4957f27d091ab1aebc69949d96e5ac2bb283ed5284a5674758b12f"));
                byte[] byArray = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), testRandomBigInteger));
                BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                if (!bigIntegerArray[0].equals(bigInteger) || !bigIntegerArray[1].equals(bigInteger2)) {
                    this.fail("F2m signature incorrect");
                }
                ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                if (!ecDsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                    this.fail("F2m signature fails");
                }
            }
        });
    }

    private static void ecPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            @Override
            void evaluate() throws Exception {
                X9ECParameters x9ECParameters = NISTNamedCurves.getByName("P-256");
                ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
                BigInteger bigInteger = new BigInteger("20186677036482506117540275567393538695075300175221296989956723148347484984008");
                ECPoint eCPoint = eCDomainParameters.getCurve().decodePoint(Hex.decode("03596375E6CE57E0F20294FC46BDFCFD19A39F8161B58695B3EC5B3D16427C274D"));
                if (!eCPoint.equals(eCDomainParameters.getG().multiply(bigInteger))) {
                    this.fail("EC primitive 'Z' computation failed");
                }
            }
        });
    }

    private static void ecF2mPrimitiveZTest() {
        SelfTestExecutor.validate(ALGORITHM, new VariantInternalKatTest(ALGORITHM){

            @Override
            void evaluate() throws Exception {
                X9ECParameters x9ECParameters = NISTNamedCurves.getByName("B-233");
                ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
                BigInteger bigInteger = new BigInteger("20186677036482506115567393538695075300175221296989956723148347484984008");
                ECPoint eCPoint = eCDomainParameters.getCurve().decodePoint(Hex.decode("03000518bce3b1b492c23094dcd7674c8ea6a3bcb7861bd2fb11be1999b796"));
                if (!eCPoint.equals(eCDomainParameters.getG().multiply(bigInteger))) {
                    this.fail("EC primitive F2m 'Z' computation failed");
                }
            }
        });
    }

    private static AsymmetricCipherKeyPair getTestKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        EcDomainParameters ecDomainParameters = ecPrivateKeyParameters.getParameters();
        BigInteger bigInteger = ecPrivateKeyParameters.getD().add(TEST_D_OFFSET).mod(ecDomainParameters.getN());
        if (bigInteger.compareTo(ECConstants.TWO) < 0) {
            bigInteger = bigInteger.add(TEST_D_OFFSET);
        }
        EcPrivateKeyParameters ecPrivateKeyParameters2 = new EcPrivateKeyParameters(bigInteger, ecDomainParameters);
        EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(ecDomainParameters.getG().multiply(bigInteger), ecDomainParameters);
        return new AsymmetricCipherKeyPair(ecPublicKeyParameters, ecPrivateKeyParameters2);
    }

    private static void validateCurveSize(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters.getCurve().getFieldSize() < 224) {
            throw new FipsUnapprovedOperationError("Attempt to use curve with field size less than 224 bits", algorithm);
        }
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters);
        }
        return new EcDomainParameters(eCDomainParameters);
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), FipsEC.getDomainParams(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    private static EcDomainParameters getDomainParamsWithInv(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters((NamedECDomainParameters)eCDomainParameters, eCDomainParameters.getInverseH());
        }
        return new EcDomainParameters(eCDomainParameters, eCDomainParameters.getInverseH());
    }

    private static EcPrivateKeyParameters getLwKeyWithInv(final AsymmetricECPrivateKey asymmetricECPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECPrivateKey.getS(), FipsEC.getDomainParamsWithInv(asymmetricECPrivateKey.getDomainParameters()));
            }
        });
    }

    static {
        FipsEC.ecPrimitiveZTest();
        FipsEC.ecF2mPrimitiveZTest();
        DomainParameterID[] domainParameterIDArray = DSA_PROVIDER.createEngine(true);
        DSA_PROVIDER.createEngine(false);
        FipsEC.f2mDsaTest((EcDsaSigner)domainParameterIDArray);
        approvedKeySet = new HashSet<ASN1ObjectIdentifier>();
        domainParameterIDArray = DomainParameterID.values();
        for (int i = 0; i != domainParameterIDArray.length; ++i) {
            String string = domainParameterIDArray[i].curveName;
            if (!Properties.isOverrideSet("org.bouncycastle.ec.enable_f2m") && (string.charAt(0) == 'B' || string.charAt(0) == 'K')) continue;
            approvedKeySet.add(ECNamedCurveTable.getOID(string));
        }
    }

    public static final class AgreementParameters
    extends FipsAgreementParameters {
        AgreementParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, null);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsAlgorithm fipsAlgorithm2) {
            super(fipsAlgorithm, fipsAlgorithm2);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.PRF pRF, byte[] byArray) {
            super(fipsAlgorithm, pRF, byArray);
        }

        private AgreementParameters(FipsAlgorithm fipsAlgorithm, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(fipsAlgorithm, agreementKDFParametersBuilder, byArray, n);
        }

        public AgreementParameters withDigest(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new AgreementParameters(this.getAlgorithm(), fipsDigestAlgorithm);
        }

        public AgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new AgreementParameters(this.getAlgorithm(), pRF, byArray);
        }

        public AgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new AgreementParameters(this.getAlgorithm(), agreementKDFParametersBuilder, byArray, n);
        }
    }

    public static final class DHAgreementFactory
    extends FipsAgreementFactory<AgreementParameters> {
        public DHAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<AgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, AgreementParameters agreementParameters) {
            if (agreementParameters.getAlgorithm() == DH.getAlgorithm()) {
                AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    if (!BigInteger.ONE.equals(asymmetricECPrivateKey.getDomainParameters().getH())) {
                        throw new FipsUnapprovedOperationError("ECDH can only be executed on curves with a co-factor of 1 in approved mode", asymmetricPrivateKey.getAlgorithm());
                    }
                    FipsEC.validateDomainParameters(asymmetricECPrivateKey.getDomainParameters());
                    FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
                }
                EcPrivateKeyParameters ecPrivateKeyParameters = !BigInteger.ONE.equals(asymmetricECPrivateKey.getDomainParameters().getH()) ? FipsEC.getLwKeyWithInv(asymmetricECPrivateKey) : FipsEC.getLwKey(asymmetricECPrivateKey);
                EcDhBasicAgreement ecDhBasicAgreement = (EcDhBasicAgreement)DH_PROVIDER.createEngine();
                ecDhBasicAgreement.init(ecPrivateKeyParameters);
                return new EcDHAgreement<AgreementParameters>(ecDhBasicAgreement, agreementParameters);
            }
            if (agreementParameters.getAlgorithm() == CDH.getAlgorithm()) {
                AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
                if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                    FipsEC.validateDomainParameters(asymmetricECPrivateKey.getDomainParameters());
                    FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
                }
                EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
                EcDhcBasicAgreement ecDhcBasicAgreement = (EcDhcBasicAgreement)CDH_PROVIDER.createEngine();
                ecDhcBasicAgreement.init(ecPrivateKeyParameters);
                return new EcDHAgreement<AgreementParameters>(ecDhcBasicAgreement, agreementParameters);
            }
            throw new IllegalArgumentException("Incorrect algorithm in parameters for EC DH: " + agreementParameters.getAlgorithm().getName());
        }
    }

    public static final class DHUAgreementFactory
    extends FipsAgreementFactory<DHUAgreementParameters> {
        public DHUAgreementFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsAgreement<DHUAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, DHUAgreementParameters dHUAgreementParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateDomainParameters(asymmetricECPrivateKey.getDomainParameters());
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
            }
            EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
            EcDhcuBasicAgreement ecDhcuBasicAgreement = (EcDhcuBasicAgreement)DHU_PROVIDER.createEngine();
            ecDhcuBasicAgreement.init(new EcDhuPrivateParameters(ecPrivateKeyParameters, dHUAgreementParameters.ephemeralPrivateKey == null ? ecPrivateKeyParameters : FipsEC.getLwKey(dHUAgreementParameters.ephemeralPrivateKey)));
            return new EcDHUAgreement<DHUAgreementParameters>(ecDhcuBasicAgreement, dHUAgreementParameters);
        }
    }

    public static final class DHUAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_DHU, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_DHU, pRF, byArray);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private DHUAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(ALGORITHM_DHU, agreementKDFParametersBuilder, byArray, n);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public DHUAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public DHUAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public DHUAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new DHUAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n);
        }
    }

    public static final class DHUAgreementParametersBuilder
    extends FipsParameters {
        DHUAgreementParametersBuilder() {
            super(ALGORITHM_DHU);
        }

        public DHUAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new DHUAgreementParameters((AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricECPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new DHUAgreementParameters(null, asymmetricECPrivateKey, asymmetricECPublicKey, null);
        }

        public DHUAgreementParameters using(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2) {
            return new DHUAgreementParameters(asymmetricECPublicKey, asymmetricECPrivateKey, asymmetricECPublicKey2, null);
        }
    }

    public static final class DSAOperatorFactory
    extends FipsSignatureOperatorFactory<DSAParameters> {
        public DSAOperatorFactory() {
            FipsEC.checkEnabled();
        }

        @Override
        public FipsOutputSignerUsingSecureRandom<DSAParameters> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, DSAParameters dSAParameters) {
            Object object;
            EcDsaSigner ecDsaSigner;
            Digest digest;
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateDomainParameters(asymmetricECPrivateKey.getDomainParameters());
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
                Utils.checkDigestAlgorithm(LOG, dSAParameters.getDigestAlgorithm(), "org.bouncycastle.ec.allow_sha1_sig");
            }
            Digest digest2 = digest = dSAParameters.digestAlgorithm != null ? FipsSHS.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            if (dSAParameters.getAlgorithm().basicVariation() == Variations.ECDSA) {
                ecDsaSigner = DSA_PROVIDER.createEngine(true);
            } else {
                object = FipsSHS.createDigest(dSAParameters.digestAlgorithm);
                if (object == null) {
                    throw new IllegalArgumentException("no HMAC support for chosen digest: " + dSAParameters.digestAlgorithm.getName());
                }
                ecDsaSigner = DSA_PROVIDER.createEngine(dSAParameters.digestAlgorithm, new HMacDsaKCalculator((Digest)object));
            }
            object = FipsEC.getLwKey(asymmetricECPrivateKey);
            return new DSAOutputSigner<DSAParameters>(ecDsaSigner, digest, dSAParameters, new DSAOutputSigner.Initializer((EcPrivateKeyParameters)object){
                final /* synthetic */ EcPrivateKeyParameters val$privateKeyParameters;
                {
                    this.val$privateKeyParameters = ecPrivateKeyParameters;
                }

                @Override
                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(this.val$privateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public FipsOutputVerifier<DSAParameters> createVerifier(AsymmetricPublicKey asymmetricPublicKey, DSAParameters dSAParameters) {
            EcDsaSigner ecDsaSigner = DSA_PROVIDER.createEngine(false);
            Digest digest = dSAParameters.digestAlgorithm != null ? FipsSHS.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), FipsEC.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
            ecDsaSigner.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<DSAParameters>(ecDsaSigner, digest, dSAParameters);
        }

        @Override
        public FipsOutputValidator<DSAParameters> createValidator(AsymmetricPublicKey asymmetricPublicKey, DSAParameters dSAParameters, byte[] byArray) throws InvalidSignatureException {
            EcDsaSigner ecDsaSigner = DSA_PROVIDER.createEngine(false);
            Digest digest = dSAParameters.digestAlgorithm != null ? FipsSHS.createDigest(dSAParameters.digestAlgorithm) : new NullDigest();
            AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECPublicKey.getW(), FipsEC.getDomainParams(asymmetricECPublicKey.getDomainParameters()));
            ecDsaSigner.init(false, ecPublicKeyParameters);
            return new DSAOutputValidator<DSAParameters>(ecDsaSigner, digest, dSAParameters, byArray);
        }
    }

    public static final class DSAParameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;

        DSAParameters(FipsAlgorithm fipsAlgorithm, FipsDigestAlgorithm fipsDigestAlgorithm) {
            super(fipsAlgorithm);
            if (fipsDigestAlgorithm == null && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                PrivilegedUtils.checkPermission(Permissions.TlsNullDigestEnabled);
            }
            if (fipsAlgorithm.basicVariation() == Variations.ECDDSA && fipsDigestAlgorithm == null) {
                throw new IllegalArgumentException("ECDDSA cannot be used with a NULL digest");
            }
            this.digestAlgorithm = fipsDigestAlgorithm;
        }

        public FipsDigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public DSAParameters withDigestAlgorithm(FipsDigestAlgorithm fipsDigestAlgorithm) {
            return new DSAParameters(this.getAlgorithm(), fipsDigestAlgorithm);
        }
    }

    private static class DhProvider
    extends FipsEngineProvider<EcDhBasicAgreement> {
        static BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhProvider() {
        }

        @Override
        public EcDhBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhBasicAgreement(), new VariantKatTest<EcDhBasicAgreement>(){

                @Override
                void evaluate(EcDhBasicAgreement ecDhBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(ecDhBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT ECDH agreement not verified");
                    }
                }
            });
        }
    }

    private static class DhcProvider
    extends FipsEngineProvider<EcDhcBasicAgreement> {
        static final BigInteger expected = new BigInteger("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17", 16);

        private DhcProvider() {
        }

        @Override
        public EcDhcBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcBasicAgreement(), new VariantKatTest<EcDhcBasicAgreement>(){

                @Override
                void evaluate(EcDhcBasicAgreement ecDhcBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhcBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
                    if (!expected.equals(ecDhcBasicAgreement.calculateAgreement(asymmetricCipherKeyPair2.getPublic()))) {
                        this.fail("KAT ECDHC agreement not verified");
                    }
                }
            });
        }
    }

    private static class DhuProvider
    extends FipsEngineProvider<EcDhcuBasicAgreement> {
        static final byte[] expected = Hex.decode("cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17cad5c428ea0645794bc5634549e08a3ed563bd0cf32e909862e08b41d4b6fc17");

        private DhuProvider() {
        }

        @Override
        public EcDhcuBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDhcuBasicAgreement(), new VariantKatTest<EcDhcuBasicAgreement>(){

                @Override
                void evaluate(EcDhcuBasicAgreement ecDhcuBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecDhcuBasicAgreement.init(new EcDhuPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    byte[] byArray = ecDhcuBasicAgreement.calculateAgreement(new EcDhuPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!Arrays.areEqual(expected, byArray)) {
                        this.fail("KAT ECCDHU agreement not verified");
                    }
                }
            });
        }
    }

    public static enum DomainParameterID implements ECDomainParametersID
    {
        B571("B-571"),
        B409("B-409"),
        B283("B-283"),
        B233("B-233"),
        K571("K-571"),
        K409("K-409"),
        K283("K-283"),
        K233("K-233"),
        P521("P-521"),
        P384("P-384"),
        P256("P-256"),
        P224("P-224"),
        brainpoolP224r1("brainpoolP224r1"),
        brainpoolP224t1("brainpoolP224t1"),
        brainpoolP256r1("brainpoolP256r1"),
        brainpoolP256t1("brainpoolP256t1"),
        brainpoolP320r1("brainpoolP320r1"),
        brainpoolP320t1("brainpoolP320t1"),
        brainpoolP384r1("brainpoolP384r1"),
        brainpoolP384t1("brainpoolP384t1"),
        brainpoolP512r1("brainpoolP512r1"),
        brainpoolP512t1("brainpoolP512t1"),
        secp256k1("secp256k1");

        private final String curveName;

        private DomainParameterID(String string2) {
            this.curveName = string2;
        }

        @Override
        public String getCurveName() {
            return this.curveName;
        }
    }

    private static class DsaProvider
    extends FipsEngineProvider<EcDsaSigner> {
        private static final BigInteger r = new BigInteger("d73cd3722bae6cc0b39065bb4003d8ece1ef2f7a8a55bfd677234b0b3b902650", 16);
        private static final BigInteger s = new BigInteger("d9c88297fefed8441e08dda69554a6452b8a0bd4a0ea1ddb750499f0c2298c2f", 16);
        private static final Map<FipsDigestAlgorithm, BigInteger[]> sigKats = new HashMap<FipsDigestAlgorithm, BigInteger[]>();
        private static final BigInteger rDetSha1 = new BigInteger("9390526f81255b33c950a4419878801be7bf3e5823468bae22bc6e4e86734ffb", 16);
        private static final BigInteger sDetSha1 = new BigInteger("5a4841d6927d9a3bc5c3b37413d798d6d01fba107411ed4b02986d15becf9670", 16);
        private static final BigInteger rDetSha224 = new BigInteger("b2f31c147179b5c27161b2cc7dcbd0f6a2d74dd5ee3b433928a0fe81a0d77d38", 16);
        private static final BigInteger sDetSha224 = new BigInteger("fb6f8c56b1b66bafc4d3294c0df57bc6ec22d12fd22da0bcb4c4741a5d10a2fd", 16);
        private static final BigInteger rDetSha256 = new BigInteger("522bb76fa0ab8f043b6be30f099b56b12bcc69f247f5a5a39cec4b02fd08b87b", 16);
        private static final BigInteger sDetSha256 = new BigInteger("32fc666aa042b991aa86a1c5f4697418484f81f91485bf8ffa51590131a7a78f", 16);
        private static final BigInteger rDetSha384 = new BigInteger("6d6b76dbf798f27e8950bd0fe6c228d78852d513613423a3ee085cca56bea0ba", 16);
        private static final BigInteger sDetSha384 = new BigInteger("71547e92702e2b6c770dc542144c8dfc5b31e6c8a8c5a8929915d0ec12cfff5", 16);
        private static final BigInteger rDetSha512 = new BigInteger("caa9a9f66852c1744fb40f1b59835337eabb0148f97f1f867ad8246cd282d0a2", 16);
        private static final BigInteger sDetSha512 = new BigInteger("946d6b64469b25d059ec8083e5cda36e4443dc98d2289a890587f49590360814", 16);
        private static final BigInteger rDetSha512_224 = new BigInteger("b92d4c176762df6027431e2b08686eeb3395cde69cf3872ff1ba864caa7f32cd", 16);
        private static final BigInteger sDetSha512_224 = new BigInteger("ab7af8d8646e917744ea5bda468e28d0d413c207135b6604862412a2ef704c40", 16);
        private static final BigInteger rDetSha512_256 = new BigInteger("57e55a88f7ea9f036ea64bd247029c821b10fd167ba6442ba2a9d89660f6c605", 16);
        private static final BigInteger sDetSha512_256 = new BigInteger("763419c86554203db3de94642877b4d74d6ac37f6cf09b58978a7b945243928e", 16);
        private static final BigInteger rDetSha3_224 = new BigInteger("5330797301a8abe67a44cc890f160fabf41dea224d7f9b139f1b3ca48b113fae", 16);
        private static final BigInteger sDetSha3_224 = new BigInteger("a95a916fec76fbbe67fa4f3903d22c20069b46e90aa15bb49e7ff27b1f7a6505", 16);
        private static final BigInteger rDetSha3_256 = new BigInteger("c79d5244c610b6f0f8ca6d848ea77e67c2cc7087b9617e9c93d52a08ee03d70", 16);
        private static final BigInteger sDetSha3_256 = new BigInteger("1ac50fbb370c75ad97d81ca98018e3422209d57fecab4427f236b67f3a148fa7", 16);
        private static final BigInteger rDetSha3_384 = new BigInteger("9f4a4e59dc8ba7dcc35ff3542c37e5d5f3a9df697573cc38156e103731181977", 16);
        private static final BigInteger sDetSha3_384 = new BigInteger("9743b86945e035447613bc3ea86885bb4855b8ff638e02bb841b4685dcc04605", 16);
        private static final BigInteger rDetSha3_512 = new BigInteger("597d41ed723bc9827cab2b011a9a540aa4082024f347d3d168166e29df5029d4", 16);
        private static final BigInteger sDetSha3_512 = new BigInteger("627f032d2252d942fabf533df4f11817fac3fd1a53559d2689a0cc368b22824e", 16);
        private static final BigInteger rDetShake128 = new BigInteger("cacabf72ff5250ff193e201b65a9c0d25ae52a4d02f67f3ad6c817fbd962c254", 16);
        private static final BigInteger sDetShake128 = new BigInteger("96ec4a5b73603df896adc6965e18be02c326cc922b3dd399c1309b0bf14aa0e4", 16);
        private static final BigInteger rDetShake256 = new BigInteger("680d40574d06cbf3c2502b76f91ebe16d4eca4607554d0036b50446526118111", 16);
        private static final BigInteger sDetShake256 = new BigInteger("bedaf371aa2de86dd3d201db52c351f6f0c5fe132a355db0e26f3922e691439e", 16);

        private DsaProvider() {
        }

        @Override
        public EcDsaSigner createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcDsaSigner(), new VariantKatTest<EcDsaSigner>(){

                @Override
                void evaluate(EcDsaSigner ecDsaSigner) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    byte[] byArray = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                    TestRandomData testRandomData = new TestRandomData(Hex.decode("a0640d4957f27d091ab1aebc69949d96e5ac2bb283ed5284a5674758b12f08df"));
                    ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), testRandomData));
                    BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                    if (!bigIntegerArray[0].equals(r) || !bigIntegerArray[1].equals(s)) {
                        this.fail("signature incorrect");
                    }
                    ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                    if (!ecDsaSigner.verifySignature(byArray, r, s)) {
                        this.fail("signature fails");
                    }
                }
            });
        }

        public EcDsaSigner createEngine(final boolean bl) {
            return SelfTestExecutor.validate(ALGORITHM, new EcDsaSigner(), new VariantKatTest<EcDsaSigner>(){

                @Override
                void evaluate(EcDsaSigner ecDsaSigner) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    byte[] byArray = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                    if (bl) {
                        TestRandomData testRandomData = new TestRandomData(Hex.decode("a0640d4957f27d091ab1aebc69949d96e5ac2bb283ed5284a5674758b12f08df"));
                        ecDsaSigner.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), testRandomData));
                        BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                        if (!bigIntegerArray[0].equals(r) || !bigIntegerArray[1].equals(s)) {
                            this.fail("signature incorrect");
                        }
                    } else {
                        ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                        if (!ecDsaSigner.verifySignature(byArray, r, s)) {
                            this.fail("signature fails");
                        }
                    }
                }
            });
        }

        public EcDsaSigner createEngine(final FipsDigestAlgorithm fipsDigestAlgorithm, HMacDsaKCalculator hMacDsaKCalculator) {
            return SelfTestExecutor.validate(ALGORITHM, new EcDsaSigner(hMacDsaKCalculator), new VariantKatTest<EcDsaSigner>(){

                @Override
                void evaluate(EcDsaSigner ecDsaSigner) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    byte[] byArray = Hex.decode("1BD4ED430B0F384B4E8D458EFF1A8A553286D7AC21CB2F6806172EF5F94A06AD");
                    ecDsaSigner.init(true, asymmetricCipherKeyPair.getPrivate());
                    BigInteger[] bigIntegerArray = ecDsaSigner.generateSignature(byArray);
                    BigInteger[] bigIntegerArray2 = (BigInteger[])sigKats.get(fipsDigestAlgorithm);
                    if (bigIntegerArray2 != null) {
                        if (!bigIntegerArray[0].equals(bigIntegerArray2[0]) || !bigIntegerArray[1].equals(bigIntegerArray2[1])) {
                            this.fail("signature incorrect");
                        }
                    } else {
                        ecDsaSigner.init(false, asymmetricCipherKeyPair.getPublic());
                        if (!ecDsaSigner.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1])) {
                            this.fail("signature check failed");
                        }
                    }
                }
            });
        }

        static {
            sigKats.put(FipsSHS.Algorithm.SHA1, new BigInteger[]{rDetSha1, sDetSha1});
            sigKats.put(FipsSHS.Algorithm.SHA224, new BigInteger[]{rDetSha224, sDetSha224});
            sigKats.put(FipsSHS.Algorithm.SHA256, new BigInteger[]{rDetSha256, sDetSha256});
            sigKats.put(FipsSHS.Algorithm.SHA384, new BigInteger[]{rDetSha384, sDetSha384});
            sigKats.put(FipsSHS.Algorithm.SHA512, new BigInteger[]{rDetSha512, sDetSha512});
            sigKats.put(FipsSHS.Algorithm.SHA512_224, new BigInteger[]{rDetSha512_224, sDetSha512_224});
            sigKats.put(FipsSHS.Algorithm.SHA512_256, new BigInteger[]{rDetSha512_256, sDetSha512_256});
            sigKats.put(FipsSHS.Algorithm.SHA3_224, new BigInteger[]{rDetSha3_224, sDetSha3_224});
            sigKats.put(FipsSHS.Algorithm.SHA3_256, new BigInteger[]{rDetSha3_256, sDetSha3_256});
            sigKats.put(FipsSHS.Algorithm.SHA3_384, new BigInteger[]{rDetSha3_384, sDetSha3_384});
            sigKats.put(FipsSHS.Algorithm.SHA3_512, new BigInteger[]{rDetSha3_512, sDetSha3_512});
            sigKats.put(FipsSHS.Algorithm.SHAKE128, new BigInteger[]{rDetShake128, sDetShake128});
            sigKats.put(FipsSHS.Algorithm.SHAKE256, new BigInteger[]{rDetShake256, sDetShake256});
        }
    }

    public static final class KeyGenParameters
    extends FipsParameters {
        private final ECDomainParameters domainParameters;

        public KeyGenParameters(ECDomainParameters eCDomainParameters) {
            this(ALGORITHM, eCDomainParameters);
        }

        public KeyGenParameters(DSAParameters dSAParameters, ECDomainParameters eCDomainParameters) {
            this(dSAParameters.getAlgorithm(), eCDomainParameters);
        }

        public KeyGenParameters(AgreementParameters agreementParameters, ECDomainParameters eCDomainParameters) {
            this(agreementParameters.getAlgorithm(), eCDomainParameters);
        }

        public KeyGenParameters(MQVAgreementParametersBuilder mQVAgreementParametersBuilder, ECDomainParameters eCDomainParameters) {
            this(ALGORITHM_MQV, eCDomainParameters);
        }

        public KeyGenParameters(DHUAgreementParametersBuilder dHUAgreementParametersBuilder, ECDomainParameters eCDomainParameters) {
            this(ALGORITHM_DHU, eCDomainParameters);
        }

        KeyGenParameters(FipsAlgorithm fipsAlgorithm, ECDomainParameters eCDomainParameters) {
            super(fipsAlgorithm);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateDomainParameters(eCDomainParameters);
            }
            this.domainParameters = eCDomainParameters;
        }

        public ECDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    public static final class KeyPairGenerator
    extends FipsAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECPublicKey, AsymmetricECPrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final ECDomainParameters domainParameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            FipsEC.checkEnabled();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateDomainParameters(keyGenParameters.getDomainParameters());
                FipsEC.validateCurveSize(keyGenParameters.getAlgorithm(), keyGenParameters.getDomainParameters());
                Utils.validateKeyPairGenRandom(secureRandom, Utils.getECCurveSecurityStrength(keyGenParameters.getDomainParameters().getCurve()), ALGORITHM);
            }
            this.param = ((KeyGenParameters)this.getParameters()).getAlgorithm().equals(DH.getAlgorithm()) && !ECConstants.ONE.equals(keyGenParameters.domainParameters.getH()) ? new EcKeyGenerationParameters(FipsEC.getDomainParamsWithInv(keyGenParameters.getDomainParameters()), secureRandom) : new EcKeyGenerationParameters(FipsEC.getDomainParams(keyGenParameters.getDomainParameters()), secureRandom);
            this.domainParameters = keyGenParameters.getDomainParameters();
            this.engine.init(this.param);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey> generateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            FipsAlgorithm fipsAlgorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            FipsEC.validateKeyPair(fipsAlgorithm, asymmetricCipherKeyPair);
            return new AsymmetricKeyPair<AsymmetricECPublicKey, AsymmetricECPrivateKey>(new AsymmetricECPublicKey((Algorithm)fipsAlgorithm, this.domainParameters, ecPublicKeyParameters.getQ()), new AsymmetricECPrivateKey((Algorithm)fipsAlgorithm, this.domainParameters, ecPrivateKeyParameters.getD(), ecPublicKeyParameters.getQ()));
        }
    }

    public static final class MQVAgreementFactory
    extends FipsAgreementFactory<MQVAgreementParameters> {
        public MQVAgreementFactory() {
            FipsEC.checkEnabled();
            if (Properties.isOverrideSet("org.bouncycastle.ec.disable_mqv")) {
                throw new UnsupportedOperationException("EC MQV has been disabled by setting \"org.bouncycastle.ec.disable_mqv\"");
            }
        }

        @Override
        public FipsAgreement<MQVAgreementParameters> createAgreement(AsymmetricPrivateKey asymmetricPrivateKey, MQVAgreementParameters mQVAgreementParameters) {
            AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)asymmetricPrivateKey;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                FipsEC.validateDomainParameters(asymmetricECPrivateKey.getDomainParameters());
                FipsEC.validateCurveSize(asymmetricPrivateKey.getAlgorithm(), asymmetricECPrivateKey.getDomainParameters());
            }
            EcPrivateKeyParameters ecPrivateKeyParameters = FipsEC.getLwKey(asymmetricECPrivateKey);
            EcMqvBasicAgreement ecMqvBasicAgreement = (EcMqvBasicAgreement)MQV_PROVIDER.createEngine();
            ecMqvBasicAgreement.init(new EcMqvPrivateParameters(ecPrivateKeyParameters, mQVAgreementParameters.ephemeralPrivateKey == null ? ecPrivateKeyParameters : FipsEC.getLwKey(mQVAgreementParameters.ephemeralPrivateKey)));
            return new EcDHAgreement<MQVAgreementParameters>(ecMqvBasicAgreement, mQVAgreementParameters);
        }
    }

    public static final class MQVAgreementParameters
    extends FipsAgreementParameters {
        private final AsymmetricECPublicKey ephemeralPublicKey;
        private final AsymmetricECPrivateKey ephemeralPrivateKey;
        private final AsymmetricECPublicKey otherPartyEphemeralKey;

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsAlgorithm fipsAlgorithm) {
            super(ALGORITHM_MQV, fipsAlgorithm);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.PRF pRF, byte[] byArray) {
            super(ALGORITHM_MQV, pRF, byArray);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        private MQVAgreementParameters(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2, FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            super(ALGORITHM_MQV, agreementKDFParametersBuilder, byArray, n);
            this.ephemeralPublicKey = asymmetricECPublicKey;
            this.ephemeralPrivateKey = asymmetricECPrivateKey;
            this.otherPartyEphemeralKey = asymmetricECPublicKey2;
        }

        public AsymmetricECPublicKey getEphemeralPublicKey() {
            return this.ephemeralPublicKey;
        }

        public AsymmetricECPrivateKey getEphemeralPrivateKey() {
            return this.ephemeralPrivateKey;
        }

        public AsymmetricECPublicKey getOtherPartyEphemeralKey() {
            return this.otherPartyEphemeralKey;
        }

        public MQVAgreementParameters withDigest(FipsAlgorithm fipsAlgorithm) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, fipsAlgorithm);
        }

        public MQVAgreementParameters withPRF(FipsKDF.PRF pRF, byte[] byArray) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, pRF, byArray);
        }

        public MQVAgreementParameters withKDF(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder, byte[] byArray, int n) {
            return new MQVAgreementParameters(this.ephemeralPublicKey, this.ephemeralPrivateKey, this.otherPartyEphemeralKey, agreementKDFParametersBuilder, byArray, n);
        }
    }

    public static final class MQVAgreementParametersBuilder
    extends FipsParameters {
        MQVAgreementParametersBuilder() {
            super(ALGORITHM_MQV);
        }

        public MQVAgreementParameters using(AsymmetricKeyPair asymmetricKeyPair, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new MQVAgreementParameters((AsymmetricECPublicKey)asymmetricKeyPair.getPublicKey(), (AsymmetricECPrivateKey)asymmetricKeyPair.getPrivateKey(), asymmetricECPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey) {
            return new MQVAgreementParameters(null, asymmetricECPrivateKey, asymmetricECPublicKey, null);
        }

        public MQVAgreementParameters using(AsymmetricECPublicKey asymmetricECPublicKey, AsymmetricECPrivateKey asymmetricECPrivateKey, AsymmetricECPublicKey asymmetricECPublicKey2) {
            return new MQVAgreementParameters(asymmetricECPublicKey, asymmetricECPrivateKey, asymmetricECPublicKey2, null);
        }
    }

    private static class MqvProvider
    extends FipsEngineProvider<EcMqvBasicAgreement> {
        static final BigInteger expected = new BigInteger("8cae3483c0d3dac87d1c1d32be8e7b7a3c1558bd01cb7e7bb37c1c81126b0f98", 16);

        private MqvProvider() {
        }

        @Override
        public EcMqvBasicAgreement createEngine() {
            return SelfTestExecutor.validate(ALGORITHM, new EcMqvBasicAgreement(), new VariantKatTest<EcMqvBasicAgreement>(){

                @Override
                void evaluate(EcMqvBasicAgreement ecMqvBasicAgreement) throws Exception {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = katKeyPair;
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair3 = FipsEC.getTestKeyPair(asymmetricCipherKeyPair);
                    ecMqvBasicAgreement.init(new EcMqvPrivateParameters((EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate(), (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()));
                    BigInteger bigInteger = ecMqvBasicAgreement.calculateAgreement(new EcMqvPublicParameters((EcPublicKeyParameters)asymmetricCipherKeyPair2.getPublic(), (EcPublicKeyParameters)asymmetricCipherKeyPair3.getPublic()));
                    if (!expected.equals(bigInteger)) {
                        this.fail("KAT ECMQV agreement not verified");
                    }
                }
            });
        }
    }

    private static enum Variations {
        ECDSA,
        ECDH,
        ECCDH,
        ECMQV,
        ECCDHU,
        ECDDSA;

    }
}

