/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ProvidedVolumeImpl;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

public class FsVolumeImplBuilder {
    private FsDatasetImpl dataset = null;
    private String storageID = null;
    private Storage.StorageDirectory sd = null;
    private Configuration conf = null;
    private FileIoProvider fileIoProvider;
    private DF usage = null;

    FsVolumeImplBuilder setDataset(FsDatasetImpl dataset) {
        this.dataset = dataset;
        return this;
    }

    FsVolumeImplBuilder setStorageID(String id) {
        this.storageID = id;
        return this;
    }

    FsVolumeImplBuilder setStorageDirectory(Storage.StorageDirectory sd) {
        this.sd = sd;
        return this;
    }

    FsVolumeImplBuilder setConf(Configuration conf) {
        this.conf = conf;
        return this;
    }

    FsVolumeImplBuilder setFileIoProvider(FileIoProvider fileIoProvider) {
        this.fileIoProvider = fileIoProvider;
        return this;
    }

    @VisibleForTesting
    FsVolumeImplBuilder setUsage(DF newUsage) {
        this.usage = newUsage;
        return this;
    }

    FsVolumeImpl build() throws IOException {
        if (this.sd.getStorageLocation().getStorageType() == StorageType.PROVIDED) {
            return new ProvidedVolumeImpl(this.dataset, this.storageID, this.sd, this.fileIoProvider != null ? this.fileIoProvider : new FileIoProvider(null, null), this.conf);
        }
        if (null == this.usage) {
            this.usage = new DF(this.sd.getCurrentDir().getParentFile(), this.conf);
        }
        return new FsVolumeImpl(this.dataset, this.storageID, this.sd, this.fileIoProvider != null ? this.fileIoProvider : new FileIoProvider(null, null), this.conf, this.usage);
    }
}

