/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeSignatureRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, RevokeSignatureRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(RevokeSignatureRequest.getter(RevokeSignatureRequest::jobId)).setter(RevokeSignatureRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobOwner").getter(RevokeSignatureRequest.getter(RevokeSignatureRequest::jobOwner)).setter(RevokeSignatureRequest.setter(Builder::jobOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(RevokeSignatureRequest.getter(RevokeSignatureRequest::reason)).setter(RevokeSignatureRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_OWNER_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeSignatureRequest.memberNameToFieldInitializer();
    private final String jobId;
    private final String jobOwner;
    private final String reason;

    private RevokeSignatureRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobOwner = builder.jobOwner;
        this.reason = builder.reason;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobOwner() {
        return this.jobOwner;
    }

    public final String reason() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSignatureRequest)) {
            return false;
        }
        RevokeSignatureRequest other = (RevokeSignatureRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobOwner(), other.jobOwner()) && Objects.equals(this.reason(), other.reason());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeSignatureRequest").add("JobId", (Object)this.jobId()).add("JobOwner", (Object)this.jobOwner()).add("Reason", (Object)this.reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobOwner": {
                return Optional.ofNullable(clazz.cast(this.jobOwner()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("jobOwner", JOB_OWNER_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeSignatureRequest, T> g) {
        return obj -> g.apply((RevokeSignatureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobOwner;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSignatureRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.jobOwner(model.jobOwner);
            this.reason(model.reason);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobOwner() {
            return this.jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeSignatureRequest build() {
            return new RevokeSignatureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeSignatureRequest> {
        public Builder jobId(String var1);

        public Builder jobOwner(String var1);

        public Builder reason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

