/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.regex;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexComposed;
import net.sourceforge.plantuml.regex.RegexPartialMatch;
import net.sourceforge.plantuml.text.StringLocated;

public class RegexRepeatedOneOrMore
extends RegexComposed
implements IRegex {
    private final String name;

    public RegexRepeatedOneOrMore(String name, IRegex partial) {
        super(partial);
        this.name = name;
    }

    @Override
    public String getPatternAsString() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.partials().get(0).getPatternAsString());
        sb.append(")+");
        return sb.toString();
    }

    @Override
    protected int getStartCount() {
        return 1;
    }

    @Override
    public final Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        String fullGroup = this.name == null ? null : it.next();
        result.putAll(super.createPartialMatch(it));
        if (this.name != null) {
            RegexPartialMatch m = new RegexPartialMatch(this.name);
            m.add(fullGroup);
            result.put(this.name, m);
        }
        return result;
    }

    @Override
    public boolean match(StringLocated full) {
        throw new UnsupportedOperationException();
    }
}

