MODULE_MAKEFILE_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))

# Run the module build.sh (wrapper for make) script with an empty environment,
# but pass PATH, KERNELDIR and eventually (if set) CC and KBUILD_MODPOST_WARN.
# The latter ones are used by driverkit build templates.
HAS_CLASS_CREATE_1 := $(shell env -i CC="$(CC)" KBUILD_MODPOST_WARN="$(KBUILD_MODPOST_WARN)" PATH="$(PATH)" KERNELDIR="$(KERNELDIR)" sh $(MODULE_MAKEFILE_DIR)/build.sh ; echo $$?)

ifeq ($(HAS_CLASS_CREATE_1),0)
$(info [configure-kmod] Setting HAS_CLASS_CREATE_1 flag)
ccflags-y += -DHAS_CLASS_CREATE_1
else
HAS_CLASS_CREATE_1_OUT := $(shell cat $(MODULE_MAKEFILE_DIR)/build.log)
$(info [configure-kmod] Build output for HAS_CLASS_CREATE_1:)
$(info [configure-kmod] $(HAS_CLASS_CREATE_1_OUT))
endif
