/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ImportInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroup;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedData;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataContentType;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.GroupIsActiveException;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.InvalidDataMemberException;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.RepositoryDoesNotExistException;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.RuntimeGroupDoesNotExistException;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.RuntimeGroupExistsException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.AnalysisManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.AppManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositorySetupManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RuntimeGroupImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.MetadataExporter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.import2.ZipDataImporter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ContactInfoImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ContactReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ContactWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroup;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupMemberWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupType;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataGroupWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSource;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.util.ZippedByteArray;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class RuntimeGroupManagerImpl
implements RuntimeGroupManager {
    protected static final String SystemDefaultText = Messages.getText("SYSTEM_DEFAULT_SOURCE_LOCATION", new Object[0]);
    private static char runtimeGroupType = MetadataGroupType.Runtime.getSqlValue();
    private Connection c = null;
    private String schema = null;
    private RepositoryVersionImpl repositoryVersion_ = null;
    private Exception creationException_ = null;

    public RuntimeGroupManagerImpl(Connection connection, String string) {
        this.c = connection;
        this.schema = string;
        try {
            this.repositoryVersion_ = (RepositoryVersionImpl)ManagerFactory.prepareConnection(connection, true, string);
        }
        catch (SQLException sQLException) {
            this.creationException_ = sQLException;
        }
        catch (MetadataException metadataException) {
            this.creationException_ = metadataException;
        }
    }

    @Override
    public List<RuntimeGroup> list() throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        if (this.isOPMRepository()) {
            AppManagerImpl appManagerImpl = new AppManagerImpl(this.c, this.schema);
            return appManagerImpl.getApps();
        }
        MetadataGroupReader metadataGroupReader = MetadataGroupReader.getInstance(this.schema);
        ArrayList<RuntimeGroup> arrayList = new ArrayList<RuntimeGroup>();
        try {
            List<MetadataGroup> list = metadataGroupReader.getValues(this.c, Character.valueOf(MetadataGroupType.Runtime.getSqlValue()));
            for (MetadataGroup metadataGroup : list) {
                boolean bl2 = metadataGroup.isActive() != null && metadataGroup.isActive().charValue() == 'Y';
                ContactInfoImpl contactInfoImpl = null;
                if (metadataGroup.getContactKey() != null) {
                    String string = metadataGroup.getContactText();
                    if (string == null) {
                        string = "";
                    }
                    contactInfoImpl = new ContactInfoImpl(metadataGroup.getContactKey(), string);
                }
                arrayList.add(new RuntimeGroupImpl(metadataGroup.getKey(), metadataGroup.getName(), metadataGroup.getVersion(), bl2, contactInfoImpl));
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_LISTING_RUNTIME_GROUPS", new Object[0]), dataRuntimeException);
        }
        return arrayList;
    }

    @Override
    public List<RuntimeGroup> list(String string) throws MetadataException {
        List<RuntimeGroup> list = this.list();
        for (int i10 = list.size() - 1; i10 >= 0; --i10) {
            if (list.get(i10).getName().equals(string)) continue;
            list.remove(i10);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void copy(String string, String string2, String string3, String string4) throws MetadataException {
        if (this.creationException_ != null) {
            if (!(this.creationException_ instanceof MetadataException)) throw new MetadataException(this.creationException_);
            throw (MetadataException)this.creationException_;
        }
        this.validateNotOPMRepository();
        MetadataGroup metadataGroup = this.validateGroupVersionExists(string, string2);
        this.validateGroupVersionDoesNotExist(string3, string4);
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        MetadataSourceReader metadataSourceReader = MetadataSourceReader.getInstance(this.schema);
        MetadataGroupMemberWriter metadataGroupMemberWriter = MetadataGroupMemberWriter.getInstance(this.schema);
        try {
            Object object;
            Integer n2 = null;
            if (metadataGroup.getContactKey() != null) {
                ContactWriter contactWriter = ContactWriter.getInstance(this.schema);
                object = ContactReader.getInstance(this.schema);
                ContactInfoImpl contactInfoImpl = ((ContactReader)object).getContactFor(this.c, string, string2, runtimeGroupType);
                n2 = contactWriter.createEntry(this.c, contactInfoImpl.getText());
            }
            int n3 = this.createImpl(string3, string4, n2);
            object = metadataSourceReader.getValuesForGroup(this.c, metadataGroup.getKey(), EnumSet.allOf(RuntimeGroupManager.MemberType.class), false);
            for (Map.Entry entry : object.entrySet()) {
                RepositorySetupManagerImpl repositorySetupManagerImpl;
                RepositoryVersion repositoryVersion;
                MetadataSource metadataSource = (MetadataSource)entry.getValue();
                int n4 = metadataSourceWriter.createEntry(this.c, metadataSource.getSource(), metadataSource.getSourceFileName());
                metadataSourceWriter.setContentFrom(this.c, metadataSource.getKey(), n4);
                metadataGroupMemberWriter.createEntry(this.c, n3, ((RuntimeGroupManager.MemberType)((Object)entry.getKey())).getSqlValue(), n4, null, null);
                if (!RuntimeGroupManager.MemberType.PDQXML.equals(entry.getKey()) || metadataSource.getContentLength() <= 0 || !(repositoryVersion = (repositorySetupManagerImpl = new RepositorySetupManagerImpl(this.c)).getRepositoryVersion(this.schema)).isFullRepository()) continue;
                AnalysisManagerImpl analysisManagerImpl = new AnalysisManagerImpl(this.c, this.schema);
                try {
                    analysisManagerImpl.analyzeRuntimeGroup(string3, string4);
                }
                catch (MetadataException metadataException) {
                    String string5 = Messages.getText("ERR_CANNOT_LOAD_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string3, string4);
                    throw new MetadataException(string5, metadataException);
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), sQLException);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String string, String string2, String string3) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        if (this.isOPMRepository()) {
            AppManagerImpl appManagerImpl = new AppManagerImpl(this.c, this.schema);
            appManagerImpl.createApp(string, string2);
            return;
        }
        this.validateGroupVersionDoesNotExist(string, string2);
        Integer n2 = null;
        if (string3 != null) {
            RuntimeGroupManager.MemberType[] memberTypeArray = ContactWriter.getInstance(this.schema);
            n2 = memberTypeArray.createEntry(this.c, string3);
        }
        this.createImpl(string, string2, n2);
        for (RuntimeGroupManager.MemberType memberType : RuntimeGroupManager.MemberType.values()) {
            if (RuntimeGroupManager.MemberType.Other.equals((Object)memberType)) continue;
            InputStream inputStream = RuntimeGroupManagerImpl.getDefaultContent(memberType);
            try {
                this.setData(string, string2, inputStream, memberType, SystemDefaultText);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string4 = Messages.getText("ERR_CANNOT_READ_DEFAULT_RUNTIME_GROUP_CONTENT", memberType.toString());
                    throw new MetadataException(string4, iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string5 = Messages.getText("ERR_CANNOT_READ_DEFAULT_RUNTIME_GROUP_CONTENT", memberType.toString());
                throw new MetadataException(string5, iOException);
            }
        }
    }

    private int createImpl(String string, String string2, Integer n2) throws MetadataException {
        MetadataGroupWriter metadataGroupWriter = MetadataGroupWriter.getInstance(this.schema);
        int n3 = metadataGroupWriter.createEntry(this.c, string, string2, Character.valueOf('N'), Character.valueOf(MetadataGroupType.Runtime.getSqlValue()), n2);
        return n3;
    }

    @Override
    public void deactivateAllVersions(String string) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        MetadataGroupWriter metadataGroupWriter = MetadataGroupWriter.getInstance(this.schema);
        int n2 = metadataGroupWriter.deactivate(this.c, string, MetadataGroupType.Runtime.getSqlValue());
        if (n2 == 0) {
            this.validateGroupExists(string);
        }
    }

    @Override
    public void delete(String string, String string2) throws MetadataException {
        Object object;
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        if (this.isOPMRepository()) {
            AppManagerImpl appManagerImpl = new AppManagerImpl(this.c, this.schema);
            appManagerImpl.removeApp(string, string2);
            return;
        }
        MetadataGroup metadataGroup = this.validateGroupVersionExists(string, string2);
        if (Character.toUpperCase(metadataGroup.isActive().charValue()) == 'Y') {
            String string3 = Messages.getText("ERR_CANNOT_REMOVE_ACTIVE_GROUP", string, string2);
            throw new GroupIsActiveException(string3, null);
        }
        MetadataGroupWriter metadataGroupWriter = MetadataGroupWriter.getInstance(this.schema);
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        RepositorySetupManagerImpl repositorySetupManagerImpl = new RepositorySetupManagerImpl(this.c);
        RepositoryVersion repositoryVersion = repositorySetupManagerImpl.getRepositoryVersion(this.schema);
        if (repositoryVersion.isFullRepository()) {
            object = new AnalysisManagerImpl(this.c, this.schema);
            ((AnalysisManagerImpl)object).removeAnalysisData(string, string2);
        }
        metadataSourceWriter.removeEntriesForGroup(this.c, string, string2);
        metadataGroupWriter.removeEntry(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue());
        if (metadataGroup.getContactKey() != null) {
            object = ContactWriter.getInstance(this.schema);
            ((ContactWriter)object).removeEntry(this.c, metadataGroup.getContactKey());
        }
    }

    @Override
    public Map<RuntimeGroupManager.MemberType, SavedData> getData(String string, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        Map<RuntimeGroupManager.MemberType, SavedData> map = this.getDataImpl(string, null, true, set);
        if (map.size() == 0) {
            this.validateGroupExists(string);
            this.validateActiveGroupExists(string);
        }
        return map;
    }

    @Override
    public Map<RuntimeGroupManager.MemberType, SavedData> getData(String string, String string2, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        Map<RuntimeGroupManager.MemberType, SavedData> map = this.getDataImpl(string, string2, false, set);
        if (map.size() == 0) {
            this.validateGroupVersionExists(string, string2);
        }
        return map;
    }

    @Override
    public Map<RuntimeGroupManager.MemberType, SavedDataInfo> getSavedDataInfo(String string, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        Map<RuntimeGroupManager.MemberType, SavedDataInfo> map = this.getSavedDataInfoImpl(string, null, true, set);
        if (map.size() == 0) {
            this.validateGroupExists(string);
            this.validateActiveGroupExists(string);
        }
        return map;
    }

    @Override
    public Map<RuntimeGroupManager.MemberType, SavedDataInfo> getSavedDataInfo(String string, String string2, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        Map<RuntimeGroupManager.MemberType, SavedDataInfo> map = this.getSavedDataInfoImpl(string, string2, false, set);
        if (map.size() == 0) {
            this.validateGroupVersionExists(string, string2);
        }
        return map;
    }

    @Override
    public void setActiveVersion(String string, String string2) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        this.validateGroupVersionExists(string, string2);
        this.deactivateAllVersions(string);
        MetadataGroupWriter metadataGroupWriter = MetadataGroupWriter.getInstance(this.schema);
        metadataGroupWriter.activate(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue());
    }

    @Override
    public void setContact(String string, String string2, String string3) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        MetadataGroupWriter metadataGroupWriter = MetadataGroupWriter.getInstance(this.schema);
        ContactWriter contactWriter = ContactWriter.getInstance(this.schema);
        MetadataGroup metadataGroup = this.validateGroupVersionExists(string, string2);
        try {
            if (string3 == null) {
                if (metadataGroup.getContactKey() != null) {
                    metadataGroupWriter.updateContactKey(this.c, string, string2, runtimeGroupType, null);
                    contactWriter.removeEntry(this.c, metadataGroup.getContactKey());
                }
            } else if (metadataGroup.getContactKey() != null) {
                contactWriter.updateEntry(this.c, metadataGroup.getContactKey(), string3);
            } else {
                int n2 = contactWriter.createEntry(this.c, string3);
                metadataGroupWriter.updateContactKey(this.c, string, string2, runtimeGroupType, n2);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
    }

    @Override
    public void setData(String string, String string2, InputStream inputStream, RuntimeGroupManager.MemberType memberType, String string3) throws MetadataException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        if (this.isOPMRepository()) {
            if (RuntimeGroupManager.MemberType.PDQXML.equals((Object)memberType)) {
                AppManagerImpl appManagerImpl = new AppManagerImpl(this.c, this.schema);
                appManagerImpl.setData(string, string2, inputStream, string3);
                return;
            }
            String string4 = Messages.getText("ERR_MEMBER_TYPE_NOT_SUPPORTED_FOR_REPOSITORY_VERSION", memberType.toString(), "2.2.1");
            throw new MetadataException(string4, null);
        }
        MetadataGroup metadataGroup = this.validateGroupVersionExists(string, string2);
        if (Character.toUpperCase(metadataGroup.isActive().charValue()) == 'Y') {
            String string5 = Messages.getText("ERR_CANNOT_UPDATE_ACTIVE_GROUP", string, string2);
            throw new GroupIsActiveException(string5, null);
        }
        RepositorySetupManagerImpl repositorySetupManagerImpl = new RepositorySetupManagerImpl(this.c);
        boolean bl2 = false;
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        ZippedByteArray zippedByteArray = ZippedByteArray.getZippedByteArray(inputStream);
        String string6 = SavedDataContentType.Other.getSqlValue();
        SavedDataContentType savedDataContentType = SavedDataContentType.fromMemberType(memberType);
        if (savedDataContentType != null) {
            string6 = savedDataContentType.getSqlValue();
        }
        if (RuntimeGroupManager.MemberType.PDQXML.equals((Object)memberType) && zippedByteArray.getOriginalDataLength() == 0) {
            String string7 = Messages.getText("ERR_INVALID_DATA_MEMBER", memberType.toString());
            throw new InvalidDataMemberException(string7, null);
        }
        int n2 = 0;
        int n3 = metadataSourceWriter.replaceEntry(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue(), memberType.getSqlValue(), string6, string3, zippedByteArray.getData(), zippedByteArray.getOriginalDataLength());
        if (n3 == 0) {
            bl2 = true;
            n2 = metadataSourceWriter.createEntry(this.c, string6, string3, zippedByteArray.getData(), zippedByteArray.getOriginalDataLength());
            object4 = MetadataGroupMemberWriter.getInstance(this.schema);
            n3 = ((MetadataGroupMemberWriter)object4).updateEntry(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue(), memberType.getSqlValue(), n2, null, null);
            if (n3 == 0) {
                ((MetadataGroupMemberWriter)object4).createEntry(this.c, metadataGroup.getKey(), memberType.getSqlValue(), n2, null, null);
            }
        } else if (RuntimeGroupManager.MemberType.PDQXML.equals((Object)memberType)) {
            object4 = MetadataSourceReader.getInstance(this.schema);
            object3 = EnumSet.of(RuntimeGroupManager.MemberType.PDQXML);
            object2 = null;
            try {
                object2 = ((MetadataSourceReader)object4).getValuesForGroup(this.c, string, string2, runtimeGroupType, (Set<RuntimeGroupManager.MemberType>)object3, false);
            }
            catch (SQLException sQLException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), sQLException);
            }
            catch (IOException iOException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), iOException);
            }
            object = object2.get((Object)RuntimeGroupManager.MemberType.PDQXML);
            if (object != null) {
                n2 = ((MetadataSource)object).getKey();
            }
        }
        if (RuntimeGroupManager.MemberType.PDQXML.equals((Object)memberType) && (object4 = repositorySetupManagerImpl.getRepositoryVersion(this.schema)).isFullRepository()) {
            object3 = new AnalysisManagerImpl(this.c, this.schema);
            if (!bl2) {
                ((AnalysisManagerImpl)object3).removeAnalysisData(string, string2);
            }
            if (zippedByteArray.getOriginalDataLength() > 0) {
                object2 = new ByteArrayInputStream(zippedByteArray.getData());
                object = new ZipInputStream((InputStream)object2);
                try {
                    ((ZipInputStream)object).getNextEntry();
                    ((AnalysisManagerImpl)object3).analyzeRuntimeGroup(string, string2, (InputStream)object, n2);
                }
                catch (IOException iOException) {
                    String string8 = Messages.getText("ERR_CANNOT_READ_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
                    throw new MetadataException(string8, iOException);
                }
                catch (MetadataException metadataException) {
                    String string9 = Messages.getText("ERR_CANNOT_LOAD_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
                    throw new MetadataException(string9, metadataException);
                }
            }
        }
    }

    private Map<RuntimeGroupManager.MemberType, SavedData> getDataImpl(String string, String string2, boolean bl2, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        Map<RuntimeGroupManager.MemberType, MetadataSource> map;
        Object object;
        boolean bl3;
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        Logger logger = Log.getLogger();
        boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
        if (bl3) {
            object = "runtimeGroupId " + string + " version " + string2 + " fetchActiveVersion " + bl2 + " types " + set;
            logger.logp(Level.FINE, "RuntimeGroupManagerImpl", "getDataImpl", (String)object);
        }
        object = MetadataSourceReader.getInstance(this.schema);
        HashMap<RuntimeGroupManager.MemberType, SavedData> hashMap = new HashMap<RuntimeGroupManager.MemberType, SavedData>();
        MetadataSource metadataSource = null;
        try {
            if (set != null && set.size() > 0) {
                map = null;
                map = !bl2 ? ((MetadataSourceReader)object).getValuesForGroup(this.c, string, string2, runtimeGroupType, set, true) : ((MetadataSourceReader)object).getValuesForGroup(this.c, string, runtimeGroupType, set, true);
                if (bl3) {
                    logger.logp(Level.FINE, "RuntimeGroupManagerImpl", "getDataImpl", "return from sql call");
                }
                for (Map.Entry entry : map.entrySet()) {
                    InputStream inputStream = ((MetadataSource)entry.getValue()).getContent();
                    if (inputStream != null) {
                        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                        zipInputStream.getNextEntry();
                        inputStream = zipInputStream;
                    }
                    hashMap.put((RuntimeGroupManager.MemberType)((Object)entry.getKey()), new SavedData(inputStream, (SavedDataInfo)entry.getValue()));
                    if (!RuntimeGroupManager.MemberType.PDQXML.equals(entry.getKey())) continue;
                    metadataSource = (MetadataSource)entry.getValue();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), sQLException);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), iOException);
        }
        if (bl3) {
            map = "No pdqxml information returned";
            if (metadataSource != null) {
                Date date = new Date(metadataSource.getImportTime());
                map = "pdqxml data size " + metadataSource.getContentLength() + " bytes.  Imported at " + date.toString() + " version choosen " + metadataSource.getGroupVersion() + " loaded from " + metadataSource.getSourceFileName();
            }
            logger.logp(Level.FINE, "RuntimeGroupManagerImpl", "getDataImpl", (String)((Object)map));
        }
        return hashMap;
    }

    private Map<RuntimeGroupManager.MemberType, SavedDataInfo> getSavedDataInfoImpl(String string, String string2, boolean bl2, Set<RuntimeGroupManager.MemberType> set) throws MetadataException {
        Object object;
        boolean bl3;
        Logger logger = Log.getLogger();
        boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.FINE);
        if (bl3) {
            object = "runtimeGroupId " + string + " version " + string2 + " fetchActiveVersion " + bl2 + " types " + set;
            logger.logp(Level.FINE, "RuntimeGroupManagerImpl", "getSavedDataInfoImpl", (String)object);
        }
        object = MetadataSourceReader.getInstance(this.schema);
        Map<RuntimeGroupManager.MemberType, MetadataSource> map = null;
        try {
            map = bl2 ? ((MetadataSourceReader)object).getValuesForGroup(this.c, string, runtimeGroupType, set, false) : ((MetadataSourceReader)object).getValuesForGroup(this.c, string, string2, runtimeGroupType, set, false);
        }
        catch (SQLException sQLException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), sQLException);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), iOException);
        }
        Map<RuntimeGroupManager.MemberType, SavedDataInfo> map2 = this.convertMap(map);
        if (bl3) {
            String string3 = "No pdqxml information returned";
            MetadataSource metadataSource = map.get((Object)RuntimeGroupManager.MemberType.PDQXML);
            if (metadataSource != null) {
                Date date = new Date(metadataSource.getImportTime());
                string3 = "pdqxml data size " + metadataSource.getContentLength() + " bytes.  Imported at " + date.toString() + " version choosen " + metadataSource.getGroupVersion() + " loaded from " + metadataSource.getSourceFileName();
            }
            logger.logp(Level.FINE, "RuntimeGroupManagerImpl", "getSavedDataInfoImpl", string3);
        }
        return map2;
    }

    private Map<RuntimeGroupManager.MemberType, SavedDataInfo> convertMap(Map<RuntimeGroupManager.MemberType, MetadataSource> map) {
        HashMap<RuntimeGroupManager.MemberType, SavedDataInfo> hashMap = new HashMap<RuntimeGroupManager.MemberType, SavedDataInfo>();
        for (Map.Entry<RuntimeGroupManager.MemberType, MetadataSource> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private MetadataGroup validateGroupVersionExists(String string, String string2) throws MetadataException {
        MetadataGroupReader metadataGroupReader = MetadataGroupReader.getInstance(this.schema);
        MetadataGroup metadataGroup = null;
        try {
            metadataGroup = metadataGroupReader.getGroup(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue());
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
        return metadataGroup;
    }

    private void validateGroupExists(String string) throws MetadataException {
        MetadataGroupReader metadataGroupReader = MetadataGroupReader.getInstance(this.schema);
        try {
            int n2 = metadataGroupReader.getNumberOfVersions(this.c, string, MetadataGroupType.Runtime.getSqlValue(), false);
            if (n2 == 0) {
                String string2 = Messages.getText("ERR_RUNTIME_GROUP_DOES_NOT_EXIST", string);
                throw new RuntimeGroupDoesNotExistException(string2, null);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
    }

    private void validateActiveGroupExists(String string) throws MetadataException {
        MetadataGroupReader metadataGroupReader = MetadataGroupReader.getInstance(this.schema);
        try {
            int n2 = metadataGroupReader.getNumberOfVersions(this.c, string, MetadataGroupType.Runtime.getSqlValue(), true);
            if (n2 == 0) {
                String string2 = Messages.getText("ERR_RUNTIME_GROUP_DOES_NOT_HAVE_AN_ACTIVE_VERSION", string);
                throw new MetadataException(string2, null);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
    }

    private void validateGroupVersionDoesNotExist(String string, String string2) throws MetadataException {
        MetadataGroupReader metadataGroupReader = MetadataGroupReader.getInstance(this.schema);
        MetadataGroup metadataGroup = null;
        try {
            metadataGroup = metadataGroupReader.getGroup(this.c, string, string2, MetadataGroupType.Runtime.getSqlValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (metadataGroup != null) {
            String string3 = Messages.getText("ERR_RUNTIME_GROUP_VERSION_EXISTS", string, string2);
            throw new RuntimeGroupExistsException(string3, null);
        }
    }

    protected static InputStream getDefaultContent(RuntimeGroupManager.MemberType memberType) {
        String string = null;
        if (RuntimeGroupManager.MemberType.BindProps.equals((Object)memberType)) {
            string = "/com/ibm/pdq/runtime/internal/repository/config/defaults/Default.bindProps";
        } else if (RuntimeGroupManager.MemberType.GenProps.equals((Object)memberType)) {
            string = "/com/ibm/pdq/runtime/internal/repository/config/defaults/Default.genProps";
        } else if (RuntimeGroupManager.MemberType.PdqProps.equals((Object)memberType)) {
            string = "/com/ibm/pdq/runtime/internal/repository/config/defaults/pdq.properties";
        } else if (RuntimeGroupManager.MemberType.PDQXML.equals((Object)memberType)) {
            string = "/com/ibm/pdq/runtime/internal/repository/config/defaults/base.pdqxml";
        }
        return RuntimeGroupManagerImpl.getDefaultContent(string);
    }

    protected static InputStream getDefaultContent(String string) {
        InputStream inputStream = null;
        URL uRL = RuntimeGroupManagerImpl.class.getResource(string);
        if (uRL != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            try {
                inputStream = new ByteArrayInputStream("".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    @Override
    public int deleteAllVersions(String string) throws MetadataException {
        int n2 = 0;
        List<RuntimeGroup> list = this.list();
        for (RuntimeGroup runtimeGroup : list) {
            if (!runtimeGroup.getName().equals(string)) continue;
            this.delete(runtimeGroup.getName(), runtimeGroup.getVersion());
            ++n2;
        }
        return n2;
    }

    @Override
    public void export(String string, String string2, OutputStream outputStream) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        this.validateNotOPMRepository();
        this.validateGroupVersionExists(string, string2);
        MetadataExporter metadataExporter = new MetadataExporter(this.c, this.schema, null, null, outputStream);
        List<String> list = Arrays.asList(string);
        List<String> list2 = Arrays.asList(string2);
        try {
            metadataExporter.exportRuntimeGroups(list, list2);
            outputStream.flush();
        }
        catch (IOException iOException) {
            String string3 = Messages.getText("ERR_EXPORT_RUNTIME_GROUP_VERSION", string, string2);
            throw new MetadataException(string3, iOException);
        }
        catch (SQLException sQLException) {
            String string4 = Messages.getText("ERR_EXPORT_RUNTIME_GROUP_VERSION", string, string2);
            throw new MetadataException(string4, sQLException);
        }
    }

    @Override
    public ImportInfo importData(String string, String string2, InputStream inputStream) throws MetadataException {
        if (this.creationException_ != null) {
            if (this.creationException_ instanceof MetadataException) {
                throw (MetadataException)this.creationException_;
            }
            throw new MetadataException(this.creationException_);
        }
        ImportInfo importInfo = null;
        if (this.isOPMRepository()) {
            AppManagerImpl appManagerImpl = new AppManagerImpl(this.c, this.schema);
            importInfo = appManagerImpl.importData(string, string2, inputStream, this.repositoryVersion_);
            return importInfo;
        }
        this.validateGroupVersionDoesNotExist(string, string2);
        RepositorySetupManagerImpl repositorySetupManagerImpl = new RepositorySetupManagerImpl(this.c);
        RepositoryVersion repositoryVersion = repositorySetupManagerImpl.getRepositoryVersion(this.schema);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipDataImporter zipDataImporter = new ZipDataImporter(this.c, this.schema, repositoryVersion);
        try {
            importInfo = zipDataImporter.loadRuntimeGroup(zipInputStream, string, string2);
        }
        catch (IOException iOException) {
            String string3 = Messages.getText("ERR_IMPORT_RUNTIME_GROUP_VERSION", string, string2);
            throw new MetadataException(string3, iOException);
        }
        return importInfo;
    }

    private void validateNotOPMRepository() throws MetadataException {
        this.fetchRepositoryVersion();
        if (this.isOPMRepository()) {
            String string = Messages.getText("ERR_FUNCTION_NOT_SUPPORTED_FOR_REPOSITORY_VERSION", "2.2.1");
            throw new MetadataException(string, null);
        }
    }

    private boolean isOPMRepository() throws MetadataException {
        this.fetchRepositoryVersion();
        boolean bl2 = this.repositoryVersion_.compareTo(RepositoryVersion.OPMVersion) <= 0;
        return bl2;
    }

    private void fetchRepositoryVersion() throws MetadataException {
        if (this.repositoryVersion_ == null) {
            String string = null;
            try {
                string = this.c.getMetaData().getURL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String string2 = Messages.getText("ERR_REPOSITORY_DOES_NOT_EXIST", new Object[]{string, this.schema, PossibleArgs.REPOSITORY_SCHEMA});
            throw new RepositoryDoesNotExistException(string2, this.creationException_);
        }
    }
}

