/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.jcc.DB2CallableStatement;
import com.ibm.db2.jcc.DB2DatabaseMetaData;
import com.ibm.db2.jcc.DB2ResultSet;
import com.ibm.db2.jcc.DBTimestamp;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class StatementUtilities {
    private static Method callStmtMethodGenericGetObject_ = null;
    private static Method resultSetIntMethodGenericGetObject_ = null;
    private static Boolean doesDatabaseSupportRowsetCursors_;
    private static boolean hasAlreadyLoggedThatDatabaseDoesNotSupportRowsets;

    public static DBTimestamp getDBTimestamp(CallableStatement callableStatement, int n2) {
        DBTimestamp dBTimestamp = null;
        if (Configuration.doesJccVersionSupportFeature(2) && callableStatement instanceof DB2CallableStatement) {
            DB2CallableStatement dB2CallableStatement = (DB2CallableStatement)callableStatement;
            if (callStmtMethodGenericGetObject_ != null) {
                Object[] objectArray = new Object[]{n2, DBTimestamp.class};
                try {
                    dBTimestamp = (DBTimestamp)callStmtMethodGenericGetObject_.invoke((Object)dB2CallableStatement, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", callStmtMethodGenericGetObject_.getName(), illegalAccessException.getMessage()), illegalAccessException, 11784);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_METHOD_INVOCATION_EXCEPTION", callStmtMethodGenericGetObject_.getName(), invocationTargetException.getMessage()), invocationTargetException, 11783);
                }
            }
        } else {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_JCC_PREREQUISITE_DAO_GETOBJECT", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__, "4.18"), null, 11782);
        }
        return dBTimestamp;
    }

    public static DBTimestamp getDBTimestamp(ResultSet resultSet, int n2) {
        DBTimestamp dBTimestamp = null;
        if (Configuration.doesJccVersionSupportFeature(2) && resultSet instanceof DB2ResultSet) {
            DB2ResultSet dB2ResultSet = (DB2ResultSet)resultSet;
            if (resultSetIntMethodGenericGetObject_ != null) {
                Object[] objectArray = new Object[]{n2, DBTimestamp.class};
                try {
                    dBTimestamp = (DBTimestamp)resultSetIntMethodGenericGetObject_.invoke((Object)dB2ResultSet, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", resultSetIntMethodGenericGetObject_.getName(), illegalAccessException.getMessage()), illegalAccessException, 11781);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_METHOD_INVOCATION_EXCEPTION", resultSetIntMethodGenericGetObject_.getName(), invocationTargetException.getMessage()), invocationTargetException, 11780);
                }
            }
        } else {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnlyNoLogging(Messages.getText("ERR_JCC_PREREQUISITE_DAO_GETOBJECT", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__, "4.18"), null, 11779);
        }
        return dBTimestamp;
    }

    public static boolean doesPureQueryAllowSQLToUseRowsetCursors(String string, SqlStatementType sqlStatementType, boolean bl2, int n2, ArrayList<Element> arrayList, int[] nArray, StringBuffer stringBuffer) {
        boolean bl3 = true;
        if (!SqlStatementType.isSELECTorVALUES(sqlStatementType)) {
            bl3 = false;
            if (null != stringBuffer) {
                stringBuffer.append(Messages.getText("ERR_REASON_NO_ROWSETS_NOTSELECT", new Object[0]));
            }
        } else if (bl2) {
            bl3 = false;
            if (null != stringBuffer) {
                stringBuffer.append(Messages.getText("ERR_REASON_NO_ROWSETS_SELECTINTO", new Object[0]));
            }
        } else if (StatementUtilities.isSqlUpdatable(string, n2)) {
            bl3 = false;
            if (null != stringBuffer) {
                stringBuffer.append(Messages.getText("ERR_REASON_NO_ROWSETS_UPDATABLE", new Object[0]));
            }
        } else if (PDQDB2Types.doColumnsContainLobOrXml(arrayList) || PDQDB2Types.doColumnsContainLobOrXml(nArray)) {
            bl3 = false;
            if (null != stringBuffer) {
                stringBuffer.append(Messages.getText("ERR_REASON_NO_ROWSETS_LOBORXML", new Object[0]));
            }
        }
        return bl3;
    }

    public static boolean checkIfShouldUseRowsetCursorInBindAndStaticExecution(boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            if (bl4 && !bl3 && !hasAlreadyLoggedThatDatabaseDoesNotSupportRowsets) {
                ToolsLogger.getLogger().log(Level.FINER, "At least one of the SQL statements that are being bound is marked to use a rowset cursor.  However, either the database does not support rowset cursors, or the database driver is not the IBM Data Server Driver for JDBC and SQLJ, so no SQL statements will be bound with rowset cursors.");
                hasAlreadyLoggedThatDatabaseDoesNotSupportRowsets = true;
            }
            return bl3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doesDatabaseSupportRowsetCursors(DatabaseMetaData databaseMetaData) {
        boolean bl2;
        if (null != doesDatabaseSupportRowsetCursors_) return doesDatabaseSupportRowsetCursors_;
        if (Configuration.isJCCPresent__) {
            if (!Configuration.checkIfFunctionalityIsAvailableInJCCVersion(57, 7)) throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Configuration.getJCCVersionNotSupportedMessage() + Messages.getText("ERR_JCC_PREREQUISITE_ROWSETS_3", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__), null, 10704);
            try {
                bl2 = ((DB2DatabaseMetaData)databaseMetaData).supportsSQLRowsetCursors();
            }
            catch (Exception exception) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_DETERMINING_IF_DB_SUPPORTS_ROWSETS", new Object[0]), exception, 10703);
            }
        } else {
            bl2 = false;
        }
        doesDatabaseSupportRowsetCursors_ = bl2;
        return doesDatabaseSupportRowsetCursors_;
    }

    public static boolean isSqlUpdatable(String string, int n2) {
        return 1008 == n2 || StaticProfileConstants.forUpdateOfPat.matcher(string).find();
    }

    public static boolean isPackageVersionAutoGenerated(String string) {
        return "AUTO".equals(string);
    }

    public static String getPackageVersion(String string, long l2) {
        String string2;
        if (!"AUTO".equals(string)) {
            string2 = string;
        } else {
            if (0L >= l2) {
                l2 = System.currentTimeMillis();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l2);
            string2 = "" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + calendar.get(11) + "." + calendar.get(12) + "." + calendar.get(13) + "." + calendar.get(14);
        }
        return string2;
    }

    private static Method findMethod(Class clazz, String string, Class ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        try {
            if (Configuration.doesJccVersionSupportFeature(2)) {
                callStmtMethodGenericGetObject_ = StatementUtilities.findMethod(DB2CallableStatement.class, "getObject", Integer.TYPE, Class.class);
                resultSetIntMethodGenericGetObject_ = StatementUtilities.findMethod(DB2ResultSet.class, "getObject", Integer.TYPE, Class.class);
            }
        }
        catch (Exception exception) {
            throw new Error(ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_EXCEPTION_OCCURRED", exception.toString()), exception, 11785));
        }
        doesDatabaseSupportRowsetCursors_ = null;
        hasAlreadyLoggedThatDatabaseDoesNotSupportRowsets = false;
    }
}

