/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonGenerationException;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonValue;

public class JsonpGeneratorWrapper
implements Wrapper,
JsonGenerator {
    OracleJsonGenerator wrapped;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public JsonpGeneratorWrapper(OracleJsonGenerator wrapped) {
        this.wrapped = wrapped;
    }

    public void close() {
        try {
            this.wrapped.close();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
    }

    public void flush() {
        try {
            this.wrapped.flush();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
    }

    public JsonGenerator writeKey(String key) {
        try {
            this.wrapped.writeKey(key);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    private JsonException translate(OracleJsonException e2) {
        if (e2 instanceof OracleJsonGenerationException) {
            return new JsonGenerationException(e2.getMessage(), (Throwable)e2);
        }
        return new JsonException(e2.getMessage(), (Throwable)e2);
    }

    public JsonGenerator write(String key, JsonValue arg) {
        try {
            this.wrapped.writeKey(key);
            this.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(JsonValue arg) {
        if (arg instanceof Wrapper) {
            Wrapper w2 = (Wrapper)arg;
            try {
                if (w2.isWrapperFor(OracleJsonValue.class)) {
                    this.wrapped.write(w2.unwrap(OracleJsonValue.class));
                    return this;
                }
            }
            catch (SQLException e2) {
                throw new IllegalStateException(e2);
            }
        }
        this.writeJsonValue(arg);
        return this;
    }

    private void writeJsonValue(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                JsonObject obj = (JsonObject)value;
                this.writeStartObject();
                for (Map.Entry entry : obj.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeJsonValue((JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                JsonArray arr = (JsonArray)value;
                this.writeStartArray();
                for (JsonValue v2 : arr) {
                    this.writeJsonValue(v2);
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString str = (JsonString)value;
                this.write(str.getString());
                break;
            }
            case NUMBER: {
                JsonNumber num = (JsonNumber)value;
                this.writeOraNum(num.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    public void writeJsonParser(Object p2) {
        JsonParser parser = (JsonParser)p2;
        int depth = 0;
        while (parser.hasNext()) {
            switch (parser.next()) {
                case END_ARRAY: {
                    this.writeEnd();
                    --depth;
                    break;
                }
                case END_OBJECT: {
                    this.writeEnd();
                    --depth;
                    break;
                }
                case KEY_NAME: {
                    this.writeKey(parser.getString());
                    break;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    ++depth;
                    break;
                }
                case START_OBJECT: {
                    this.writeStartObject();
                    ++depth;
                    break;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    break;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    break;
                }
                case VALUE_NUMBER: {
                    this.writeOraNum(parser.getBigDecimal());
                    break;
                }
                case VALUE_STRING: {
                    this.write(parser.getString());
                    break;
                }
                case VALUE_TRUE: {
                    this.write(true);
                }
            }
            if (depth > 0) continue;
            break;
        }
    }

    public JsonGenerator write(String arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(BigDecimal arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(BigInteger arg) {
        this.wrapped.write(arg);
        return this;
    }

    public JsonGenerator write(int arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(long arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(double arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(boolean arg) {
        try {
            this.wrapped.write(arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, String arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, BigInteger arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, BigDecimal arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, int arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, long arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, double arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator write(String key, boolean arg) {
        try {
            this.wrapped.write(key, arg);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeEnd() {
        try {
            this.wrapped.writeEnd();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeNull() {
        try {
            this.wrapped.writeNull();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeNull(String key) {
        try {
            this.wrapped.writeNull(key);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeStartArray() {
        try {
            this.wrapped.writeStartArray();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeStartArray(String key) {
        try {
            this.wrapped.writeStartArray(key);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeStartObject() {
        try {
            this.wrapped.writeStartObject();
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    public JsonGenerator writeStartObject(String key) {
        try {
            this.wrapped.writeStartObject(key);
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> wrapped) throws SQLException {
        if (wrapped.isInstance(this.wrapped)) {
            return (T)this.wrapped;
        }
        throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, wrapped.getName()).getMessage());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.wrapped);
    }

    private void writeOraNum(BigDecimal value) {
        try {
            this.wrapped.write(new OracleJsonDecimalImpl(value));
        }
        catch (OracleJsonException e2) {
            throw this.translate(e2);
        }
    }

    static {
        try {
            $$$methodRef$$$32 = JsonpGeneratorWrapper.class.getDeclaredConstructor(OracleJsonGenerator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeOraNum", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JsonpGeneratorWrapper.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JsonpGeneratorWrapper.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeStartObject", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeStartArray", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeJsonParser", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeJsonValue", JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonpGeneratorWrapper.class.getDeclaredMethod("write", String.class, JsonValue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonpGeneratorWrapper.class.getDeclaredMethod("translate", OracleJsonException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonpGeneratorWrapper.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonpGeneratorWrapper.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonpGeneratorWrapper.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

