/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.type.ArrayType;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapLikeType;
import tools.jackson.databind.type.MapType;
import tools.jackson.databind.type.ReferenceType;

public interface Serializers {
    default public ValueSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides) {
        return null;
    }

    default public ValueSerializer<?> findArraySerializer(SerializationConfig config, ArrayType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, ValueSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, ValueSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, ValueSerializer<Object> elementValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findEnumSerializer(SerializationConfig config, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides) {
        return null;
    }

    default public ValueSerializer<?> findTreeNodeSerializer(SerializationConfig config, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides) {
        return null;
    }

    default public ValueSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides, TypeSerializer contentTypeSerializer, ValueSerializer<Object> contentValueSerializer) {
        return null;
    }

    default public ValueSerializer<?> findExplicitPOJOSerializer(SerializationConfig config, JavaType type, BeanDescription.Supplier beanDescRef, JsonFormat.Value formatOverrides) {
        return null;
    }

    public static class Base
    implements Serializers {
        protected JsonFormat.Value calculateEffectiveFormat(BeanDescription.Supplier beanDescRef, Class<?> baseType, JsonFormat.Value formatOverrides) {
            JsonFormat.Value fromType = beanDescRef.findExpectedFormat(baseType);
            if (formatOverrides == null) {
                return fromType;
            }
            return JsonFormat.Value.merge((JsonFormat.Value)fromType, (JsonFormat.Value)formatOverrides);
        }
    }
}

