/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIExceptionWrapper;
import org.graalvm.jniutils.JNIUtil;

public final class JNICalls {
    private static final JNICalls INSTANCE = new JNICalls(JNIExceptionWrapper.ExceptionHandler.DEFAULT);
    private static final ThreadLocal<Boolean> inTrace = ThreadLocal.withInitial(() -> false);
    private final JNIExceptionWrapper.ExceptionHandler exceptionHandler;

    private JNICalls(JNIExceptionWrapper.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public static JNICalls getDefault() {
        return INSTANCE;
    }

    public static JNICalls createWithExceptionHandler(JNIExceptionWrapper.ExceptionHandler handler) {
        Objects.requireNonNull(handler, "Handler must be non null.");
        return new JNICalls(handler);
    }

    @JNICall
    public void callStaticVoid(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, method);
        env.getFunctions().getCallStaticVoidMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
    }

    @JNICall
    public boolean callStaticBoolean(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, method);
        boolean res = env.getFunctions().getCallStaticBooleanMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public long callStaticLong(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, method);
        long res = env.getFunctions().getCallStaticLongMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public int callStaticInt(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, method);
        int res = env.getFunctions().getCallStaticIntMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public <R extends JNI.JObject> R callStaticJObject(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, method);
        JNI.JObject res = env.getFunctions().getCallStaticObjectMethodA().call(env, clazz, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @JNICall
    public <R extends JNI.JObject> R callNewObject(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod constructor, JNI.JValue args) {
        JNICalls.traceCall(env, clazz, constructor);
        JNI.JObject res = env.getFunctions().getNewObjectA().call(env, clazz, constructor.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @JNICall
    public void callVoid(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        env.getFunctions().getCallVoidMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
    }

    @JNICall
    public <R extends JNI.JObject> R callJObject(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        JNI.JObject res = env.getFunctions().getCallObjectMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return (R)res;
    }

    @JNICall
    public boolean callBoolean(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        boolean res = env.getFunctions().getCallBooleanMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public short callShort(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        short res = env.getFunctions().getCallShortMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public int callInt(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        int res = env.getFunctions().getCallIntMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public long callLong(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        long res = env.getFunctions().getCallLongMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public double callDouble(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        double res = env.getFunctions().getCallDoubleMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public float callFloat(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        float res = env.getFunctions().getCallFloatMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public byte callByte(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        byte res = env.getFunctions().getCallByteMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    @JNICall
    public char callChar(JNI.JNIEnv env, JNI.JObject object, JNIMethod method, JNI.JValue args) {
        JNICalls.traceCall(env, object, method);
        char res = env.getFunctions().getCallCharMethodA().call(env, object, method.getJMethodID(), args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, this.exceptionHandler);
        return res;
    }

    private static void traceCall(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method) {
        if (JNIUtil.tracingAt(1)) {
            JNICalls.traceCallImpl(env, clazz, method);
        }
    }

    private static void traceCall(JNI.JNIEnv env, JNI.JObject receiver, JNIMethod method) {
        if (JNIUtil.tracingAt(1)) {
            JNICalls.traceCallImpl(env, env.getFunctions().getGetObjectClass().call(env, receiver), method);
        }
    }

    private static void traceCallImpl(JNI.JNIEnv env, JNI.JClass clazz, JNIMethod method) {
        if (!inTrace.get().booleanValue()) {
            inTrace.set(true);
            try {
                JNIUtil.trace(1, "%s->HS: %s::%s", JNIUtil.getFeatureName(), JNICalls.toSimpleName(JNIUtil.createString(env, (JNI.JString)JNIExceptionWrapper.callGetClassName(env, clazz))), method.getDisplayName());
            }
            finally {
                inTrace.remove();
            }
        }
    }

    private static String toSimpleName(String fqn) {
        int separatorIndex = fqn.lastIndexOf(46);
        return separatorIndex < 0 || separatorIndex + 1 == fqn.length() ? fqn : fqn.substring(separatorIndex + 1);
    }

    public static interface JNIMethod {
        public JNI.JMethodID getJMethodID();

        public String getDisplayName();

        public static JNIMethod findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, String methodName, String methodSignature) {
            return JNIMethod.findMethod(env, clazz, staticMethod, true, methodName, methodSignature);
        }

        public static JNIMethod findMethod(JNI.JNIEnv env, JNI.JClass clazz, boolean staticMethod, boolean required, final String methodName, final String methodSignature) {
            final JNI.JMethodID methodID = JNIUtil.findMethod(env, clazz, staticMethod, required, methodName, methodSignature);
            return methodID.isNull() ? null : new JNIMethod(){

                @Override
                public JNI.JMethodID getJMethodID() {
                    return methodID;
                }

                @Override
                public String getDisplayName() {
                    return methodName;
                }

                public String toString() {
                    return methodName + methodSignature + "[0x" + Long.toHexString(methodID.rawValue()) + "]";
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface JNICall {
    }
}

