/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import org.bson.AbstractBsonWriter;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.json.Converter;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.json.LessSpaceStrictJsonWriter;
import org.bson.json.StrictJsonWriter;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RestJsonWriter
extends AbstractBsonWriter
implements BsonWriter {
    private final JsonWriterSettings settings;
    private final LessSpaceStrictJsonWriter strictJsonWriter;

    public RestJsonWriter() {
        this(new JsonWriterSettings());
    }

    public RestJsonWriter(JsonWriterSettings settings) {
        super((BsonWriterSettings)settings);
        this.settings = settings;
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL));
        this.strictJsonWriter = new LessSpaceStrictJsonWriter();
    }

    public String getJson() {
        return this.strictJsonWriter.getJson();
    }

    protected Context getContext() {
        return (Context)super.getContext();
    }

    protected void doWriteName(String name) {
        this.strictJsonWriter.writeName(name);
    }

    protected void doWriteStartDocument() {
        this.strictJsonWriter.writeStartObject();
        BsonContextType contextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        this.setContext(new Context(this.getContext(), contextType));
    }

    protected void doWriteEndDocument() {
        this.strictJsonWriter.writeEndObject();
        if (this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
            this.setContext(this.getContext().getParentContext());
            this.writeEndDocument();
        } else {
            this.setContext(this.getContext().getParentContext());
        }
    }

    protected void doWriteStartArray() {
        this.strictJsonWriter.writeStartArray();
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    protected void doWriteEndArray() {
        this.strictJsonWriter.writeEndArray();
        this.setContext(this.getContext().getParentContext());
    }

    protected void doWriteBinaryData(BsonBinary binary) {
        this.settings.getBinaryConverter().convert((Object)binary, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteBoolean(boolean value) {
        this.settings.getBooleanConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteDateTime(long value) {
        this.settings.getDateTimeConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteDBPointer(BsonDbPointer value) {
        if (this.settings.getOutputMode() == JsonMode.EXTENDED) {
            new Converter<BsonDbPointer>(){

                public void convert(BsonDbPointer value1, StrictJsonWriter writer) {
                    writer.writeStartObject();
                    writer.writeStartObject("$dbPointer");
                    writer.writeString("$ref", value1.getNamespace());
                    writer.writeName("$id");
                    RestJsonWriter.this.doWriteObjectId(value1.getId());
                    writer.writeEndObject();
                    writer.writeEndObject();
                }
            }.convert(value, (StrictJsonWriter)this.strictJsonWriter);
        } else {
            new Converter<BsonDbPointer>(){

                public void convert(BsonDbPointer value1, StrictJsonWriter writer) {
                    writer.writeStartObject();
                    writer.writeString("$ref", value1.getNamespace());
                    writer.writeName("$id");
                    RestJsonWriter.this.doWriteObjectId(value1.getId());
                    writer.writeEndObject();
                }
            }.convert(value, (StrictJsonWriter)this.strictJsonWriter);
        }
    }

    protected void doWriteDouble(double value) {
        this.settings.getDoubleConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteInt32(int value) {
        this.settings.getInt32Converter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteInt64(long value) {
        this.settings.getInt64Converter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteDecimal128(Decimal128 value) {
        this.settings.getDecimal128Converter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteJavaScript(String code) {
        this.settings.getJavaScriptConverter().convert((Object)code, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteJavaScriptWithScope(String code) {
        this.writeStartDocument();
        this.writeString("$code", code);
        this.writeName("$scope");
    }

    protected void doWriteMaxKey() {
        this.settings.getMaxKeyConverter().convert(null, (StrictJsonWriter)this.strictJsonWriter);
    }

    protected void doWriteMinKey() {
        this.settings.getMinKeyConverter().convert(null, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteNull() {
        this.settings.getNullConverter().convert(null, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteObjectId(ObjectId objectId) {
        this.settings.getObjectIdConverter().convert((Object)objectId, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteRegularExpression(BsonRegularExpression regularExpression) {
        this.settings.getRegularExpressionConverter().convert((Object)regularExpression, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteString(String value) {
        this.settings.getStringConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteSymbol(String value) {
        this.settings.getSymbolConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteTimestamp(BsonTimestamp value) {
        this.settings.getTimestampConverter().convert((Object)value, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void doWriteUndefined() {
        this.settings.getUndefinedConverter().convert(null, (StrictJsonWriter)this.strictJsonWriter);
    }

    public void flush() {
    }

    public boolean isTruncated() {
        return this.strictJsonWriter.isTruncated();
    }

    protected boolean abortPipe() {
        return this.strictJsonWriter.isTruncated();
    }

    public class Context
    extends AbstractBsonWriter.Context {
        @Deprecated
        public Context(Context parentContext, BsonContextType contextType, String indentChars) {
            this(parentContext, contextType);
        }

        public Context(Context parentContext, BsonContextType contextType) {
            super((AbstractBsonWriter)RestJsonWriter.this, (AbstractBsonWriter.Context)parentContext, contextType);
        }

        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

