/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schema.NamedObject;
import us.fatehi.utility.Utility;

public enum NamedObjectSort implements Comparator<NamedObject>
{
    alphabetical(Comparator.comparing(namedObject -> Utility.convertForComparison((String)namedObject.getFullName()))),
    natural(Comparator.naturalOrder());

    private final Comparator<NamedObject> comparator;

    public static NamedObjectSort getNamedObjectSort(boolean alphabeticalSort) {
        if (alphabeticalSort) {
            return alphabetical;
        }
        return natural;
    }

    private NamedObjectSort(Comparator<NamedObject> comparator) {
        this.comparator = Comparator.nullsLast(comparator);
    }

    @Override
    public int compare(NamedObject namedObject1, NamedObject namedObject2) {
        return Objects.compare(namedObject1, namedObject2, this.comparator);
    }
}

