/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.builtins.objects.types.GenericAliasIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.GenericAliasIteratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PGenericAliasIterator;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenericAliasIterator})
public final class GenericAliasIteratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = GenericAliasIteratorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericAliasIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PGenericAliasIterator self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Bind PythonLanguage language) {
            PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
            Object iter = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            Object[] args = !self.isExhausted() ? new Object[]{self.getObj()} : new Object[]{PFactory.createEmptyTuple(language)};
            return PFactory.createTuple(language, new Object[]{iter, PFactory.createTuple(language, args)});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        NextNode() {
        }

        @Specialization
        static Object next(PGenericAliasIterator self, @Bind PythonLanguage language) {
            if (self.isExhausted()) {
                throw NextNode.iteratorExhausted();
            }
            PGenericAlias alias = self.getObj();
            PGenericAlias starredAlias = PFactory.createGenericAlias(language, alias.getOrigin(), alias.getArgs(), true);
            self.markExhausted();
            return starredAlias;
        }
    }
}

