/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

public final class PythonCextFloatBuiltins {

    static abstract class PyFloat_FromString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyFloat_FromString() {
        }

        @Specialization
        static Object fromString(Object string, @Bind Node inliningTarget, @Cached PyFloatFromString pyFloatFromString) {
            return pyFloatFromString.execute(null, inliningTarget, string);
        }
    }

    static abstract class GraalPyPrivate_Float_AsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Float_AsDouble() {
        }

        @Specialization
        static double doLongNativeWrapper(long object) {
            return object;
        }

        @Specialization
        static double doDoubleNativeWrapper(double object) {
            return object;
        }

        @Specialization(guards={"!isLong(object)", "!isDouble(object)"})
        static double doGenericErr(Object object, @Bind Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyFloat_FromDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyFloat_FromDouble() {
        }

        @Specialization
        static double fromDouble(double d) {
            return d;
        }

        @Specialization(guards={"!isDouble(obj)"})
        static Object fromDouble(Object obj, @Bind Node inliningTarget, @Cached StringBuiltins.StrNewNode strNode) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_WAS_S_P, strNode.executeWith(null, obj), obj);
        }
    }
}

