/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecCtxBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStatefulCodecContext;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteIncrementalDecoder, PythonBuiltinClassType.MultibyteIncrementalEncoder, PythonBuiltinClassType.MultibyteStreamReader, PythonBuiltinClassType.MultibyteStreamWriter})
public final class CodecCtxBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodecCtxBuiltinsFactory.getFactories();
    }

    @Builtin(name="errors", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="how to treat errors")
    @GenerateNodeFactory
    protected static abstract class CodecCtxNode
    extends PythonBinaryBuiltinNode {
        protected CodecCtxNode() {
        }

        @Specialization(guards={"isNoValue(ignored)"})
        static Object codecctxErrorsGet(MultibyteStatefulCodecContext self, PNone ignored) {
            return self.errors;
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object codecctxErrorsSet(MultibyteStatefulCodecContext self, Object value, @Bind Node inliningTarget, @Cached TruffleString.EqualNode isEqual, @Cached CastToTruffleStringNode castToStringNode, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached PRaiseNode raiseNode) {
            if (value == PNone.NONE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.CANNOT_DELETE);
            }
            if (!unicodeCheckNode.execute(inliningTarget, value)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ERRORS_MUST_BE_A_STRING);
            }
            TruffleString str = castToStringNode.execute(inliningTarget, value);
            self.errors = MultibyteCodecUtil.internalErrorCallback(str, isEqual);
            return PNone.NONE;
        }
    }
}

