/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCPointer})
public final class PyCPointerBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PyCPointerBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCPointerBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CDATA_INIT_BUFFER_PROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.PyCPointer)));
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class PointerSubscriptNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        PointerSubscriptNode() {
        }

        @Specialization
        static Object doInt(CDataObject self, int index, @Bind Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return PointerGetItemNode.Pointer_item(self, index, inliningTarget, pyCDataGetNode, pyTypeStgDictNode, pyObjectStgDictNode, readPointerNode, raiseNode);
        }

        @Specialization(limit="1")
        static Object doSubscript(VirtualFrame frame, CDataObject self, PSlice slice, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(value="self") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            int start;
            int step;
            if (slice.getStep() == PNone.NONE) {
                step = 1;
            } else {
                step = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStep(), PythonErrorType.ValueError);
                if (step == 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
                }
            }
            if (slice.getStart() == PNone.NONE) {
                if (step < 0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_START_IS_REQUIRED_FOR_STEP_0);
                }
                start = 0;
            } else {
                start = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStart(), PythonErrorType.ValueError);
            }
            if (slice.getStop() == PNone.NONE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.SLICE_STOP_IS_REQUIRED);
            }
            int stop = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStop(), PythonErrorType.ValueError);
            int len = step > 0 && start > stop || step < 0 && start < stop ? 0 : (step > 0 ? (stop - start - 1) / step + 1 : (stop - start + 1) / step + 1);
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null);
            if (itemdict.getfunc == FFIType.FieldDesc.c.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (len <= 0) {
                    return PFactory.createEmptyBytes(language);
                }
                if (start == 0 && step == 1) {
                    return PFactory.createBytes(language, ptr, len);
                }
                byte[] dest = new byte[len];
                int cur = start;
                for (int i = 0; i < len; ++i) {
                    dest[i] = ptr[cur];
                    cur += step;
                }
                return PFactory.createBytes(language, dest);
            }
            if (itemdict.getfunc == FFIType.FieldDesc.u.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (len <= 0) {
                    return StringLiterals.T_EMPTY_STRING;
                }
                if (step == 1) {
                    return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(ptr, start, len, TruffleString.Encoding.UTF_8, true), PythonUtils.TS_ENCODING);
                }
                byte[] dest = new byte[len];
                int cur = start;
                for (int i = 0; i < len; ++i) {
                    dest[i] = ptr[cur];
                    cur += step;
                }
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(dest, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
            }
            Object[] np = new Object[len];
            int cur = start;
            for (int i = 0; i < len; ++i) {
                np[i] = PointerGetItemNode.Pointer_item(self, cur, inliningTarget, pyCDataGetNode, pyTypeStgDictNode, pyObjectStgDictNode, readPointerNode, raiseNode);
                cur += step;
            }
            return PFactory.createList(language, np);
        }

        @Specialization(guards={"!isPSlice(item)"}, replaces={"doInt"})
        static Object doGeneric(VirtualFrame frame, CDataObject self, Object item, @Bind Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (indexCheckNode.execute(inliningTarget, item)) {
                int i = asSizeNode.executeExact((Frame)frame, inliningTarget, item, PythonErrorType.IndexError);
                return PointerGetItemNode.Pointer_item(self, i, inliningTarget, pyCDataGetNode, pyTypeStgDictNode, pyObjectStgDictNode, readPointerNode, raiseNode);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.POINTER_INDICES_MUST_BE_INTEGER);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class PointerGetItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        PointerGetItemNode() {
        }

        @Specialization
        static Object Pointer_item(CDataObject self, int index, @Bind Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (self.b_ptr.isNull()) {
                PointerGetItemNode.raiseNullPtr(inliningTarget, raiseNode);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer object instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null) : "proto is the item type of the pointer, a ctypes type, so this cannot be NULL";
            int size = itemdict.size;
            int offset = index * itemdict.size;
            return pyCDataGetNode.execute(inliningTarget, proto, stgdict.getfunc, self, index, size, readPointerNode.execute(inliningTarget, self.b_ptr).withOffset(offset));
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseNullPtr(Node inliningTarget, PRaiseNode raiseNode) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
        }
    }

    @Slot(value=Slot.SlotKind.sq_ass_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class PointerSetItemNode
    extends TpSlotSqAssItem.SqAssItemBuiltinNode {
        PointerSetItemNode() {
        }

        @Specialization
        static void Pointer_ass_item(VirtualFrame frame, CDataObject self, int index, Object value, @Bind Node inliningTarget, @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PRaiseNode raiseNode) {
            if (value == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.POINTER_DOES_NOT_SUPPORT_ITEM_DELETION);
            }
            if (self.b_ptr.isNull()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null) : "Cannot be NULL because the itemtype of a pointer is always a ctypes type";
            int size = itemdict.size;
            int offset = index * itemdict.size;
            pyCDataSetNode.execute(frame, self, proto, stgdict.setfunc, value, index, size, readPointerNode.execute(inliningTarget, self.b_ptr).withOffset(offset));
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    protected static abstract class PointerBoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        protected PointerBoolNode() {
        }

        @Specialization
        boolean Pointer_bool(CDataObject self) {
            return !self.b_ptr.isNull();
        }
    }

    @Builtin(name="contents", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="the object this pointer points to (read-write)")
    @GenerateNodeFactory
    protected static abstract class PointerContentSNode
    extends PythonBinaryBuiltinNode {
        protected PointerContentSNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object get_contents(CDataObject self, PNone value, @Bind Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CtypesNodes.PyCDataFromBaseObjNode fromBaseObjNode, @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PRaiseNode raiseNode) {
            if (self.b_ptr.isNull()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            return fromBaseObjNode.execute(inliningTarget, stgdict.proto, self, 0, readPointerNode.execute(inliningTarget, self.b_ptr));
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object set_contents(VirtualFrame frame, CDataObject self, Object value, @Bind Node inliningTarget, @Cached PointerSetContentsNode setContentsNode) {
            setContentsNode.execute(frame, inliningTarget, self, value);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        static Object Pointer_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached PointerSetContentsNode setContentsNode) {
            if (args.length > 0) {
                setContentsNode.execute(frame, inliningTarget, self, args[0]);
            }
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object Pointer_new(Object type, Object[] args, PKeyword[] kwds, @Bind Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached PRaiseNode raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            if (dict.proto == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCE_HAS_NO_TYPE);
            }
            return pyCDataNewNode.execute(inliningTarget, type, dict);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PointerSetContentsNode
    extends Node {
        PointerSetContentsNode() {
        }

        abstract void execute(VirtualFrame var1, Node var2, CDataObject var3, Object var4);

        @Specialization
        static void set(VirtualFrame frame, Node inliningTarget, CDataObject self, Object value, @Bind PythonLanguage language, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached PRaiseNode raiseNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached(inline=false) BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached PointerNodes.WritePointerNode writePointerNode) {
            boolean res;
            if (value == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.POINTER_DOES_NOT_SUPPORT_ITEM_DELETION);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            assert (stgdict.proto != null);
            if (!pyTypeCheck.isCDataObject(inliningTarget, value) && !(res = isInstanceNode.executeWith(frame, value, stgdict.proto))) {
                raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_N_INSTEAD_OF_P, stgdict.proto, value);
            }
            CDataObject dst = (CDataObject)value;
            writePointerNode.execute(inliningTarget, self.b_ptr, dst.b_ptr);
            keepRefNode.execute(frame, inliningTarget, self, 1, value);
            Object keep = CDataTypeBuiltins.GetKeepedObjects(dst, language);
            keepRefNode.execute(frame, inliningTarget, self, 0, keep);
        }
    }
}

