/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.frame;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

public final class PFrame
extends PythonBuiltinObject {
    private static final int UNINITIALIZED_LINE = -2;
    private Object[] arguments;
    private final MaterializedFrame locals;
    private Object localsDict;
    private final Reference virtualFrameInfo;
    private Node location;
    private RootCallTarget callTarget;
    private int line = -2;
    private int bci = -1;
    private boolean lockLine = false;
    public static final int DISALLOW_JUMPS = -3;
    public static final int NO_JUMP = -2;
    private int jumpDestLine = -3;
    private Object localTraceFun = null;
    private boolean traceLine = true;
    private Reference backref = null;

    public Object getLocalTraceFun() {
        return this.localTraceFun;
    }

    public void setLocalTraceFun(Object localTraceFun) {
        this.localTraceFun = localTraceFun;
    }

    public boolean getTraceLine() {
        return this.traceLine;
    }

    public void setTraceLine(boolean traceLine) {
        this.traceLine = traceLine;
    }

    public boolean isTraceArgument() {
        return this.jumpDestLine != -3;
    }

    public int getJumpDestLine() {
        return this.jumpDestLine;
    }

    public void setJumpDestLine(int jumpDestLine) {
        this.jumpDestLine = jumpDestLine;
    }

    public PFrame(PythonLanguage lang, Reference virtualFrameInfo, Node location, MaterializedFrame locals) {
        super((Object)PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PFrame.getInstanceShape(lang));
        this.virtualFrameInfo = virtualFrameInfo;
        this.locals = locals;
        this.location = location;
    }

    public PFrame(PythonLanguage lang, Object threadState, PCode code, PythonObject globals, Object localsDict) {
        super((Object)PythonBuiltinClassType.PFrame, PythonBuiltinClassType.PFrame.getInstanceShape(lang));
        Reference curFrameInfo;
        Object[] frameArgs = PArguments.create();
        PArguments.setGlobals(frameArgs, globals);
        PArguments.setSpecialArgument(frameArgs, localsDict);
        this.location = CodeNodes.GetCodeRootNode.executeUncached(code);
        this.virtualFrameInfo = curFrameInfo = new Reference(this.location != null ? this.location.getRootNode() : null, null);
        curFrameInfo.setPyFrame(this);
        this.line = this.location == null ? code.getFirstLineNo() : -2;
        this.arguments = frameArgs;
        this.locals = null;
        this.localsDict = localsDict;
    }

    public MaterializedFrame getLocals() {
        return this.locals;
    }

    public Object getLocalsDict() {
        return this.localsDict;
    }

    public boolean hasCustomLocals() {
        return this.locals == null;
    }

    public void setLocalsDict(Object dict) {
        this.localsDict = dict;
    }

    public Reference getRef() {
        return this.virtualFrameInfo;
    }

    public Reference getBackref() {
        return this.backref;
    }

    public void setBackref(Reference backref) {
        this.backref = backref;
    }

    public void setLine(int line) {
        if (this.lockLine) {
            return;
        }
        this.line = line;
    }

    public void setLineLock(int line) {
        this.line = line;
        this.lockLine = true;
    }

    public void lineUnlock() {
        this.lockLine = false;
    }

    public boolean didJump() {
        return this.jumpDestLine > -2;
    }

    @CompilerDirectives.TruffleBoundary
    public int getLine() {
        if (this.line == -2) {
            if (this.location == null) {
                this.line = -1;
            } else if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                Node node = this.location;
                if (node instanceof BytecodeNode) {
                    BytecodeNode bytecodeNode = (BytecodeNode)node;
                    PBytecodeDSLRootNode rootNode = (PBytecodeDSLRootNode)bytecodeNode.getRootNode();
                    return rootNode.bciToLine(this.bci, bytecodeNode);
                }
            } else {
                Node node = this.location;
                if (node instanceof PBytecodeRootNode) {
                    PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)node;
                    return bytecodeRootNode.bciToLine(this.bci);
                }
            }
        }
        return this.line;
    }

    public PythonObject getGlobals() {
        return PArguments.getGlobals(this.arguments);
    }

    public RootCallTarget getTarget() {
        if (this.callTarget == null) {
            if (this.location != null) {
                this.callTarget = PythonUtils.getOrCreateCallTarget(this.location.getRootNode());
            } else if (this.getRef() != null && this.getRef().getRootNode() != null) {
                this.callTarget = PythonUtils.getOrCreateCallTarget(this.getRef().getRootNode());
            }
        }
        return this.callTarget;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments2) {
        this.arguments = arguments2;
    }

    public void setLocation(Node location) {
        this.location = location;
    }

    public Node getLocation() {
        return this.location;
    }

    public BytecodeNode getBytecodeNode() {
        BytecodeNode bytecodeNode;
        Node node = this.location;
        return node instanceof BytecodeNode ? (bytecodeNode = (BytecodeNode)node) : null;
    }

    public int getBci() {
        return this.bci;
    }

    public void setBci(int bci) {
        this.bci = bci;
    }

    public int getLasti() {
        return PFrame.bciToLasti(this.bci, this.location);
    }

    @CompilerDirectives.TruffleBoundary
    public static int bciToLasti(int bci, Node location) {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            if (bci >= 0 && location instanceof BytecodeNode) {
                BytecodeNode bytecodeNode = (BytecodeNode)location;
                return PBytecodeDSLRootNode.bciToLasti(bci, bytecodeNode);
            }
        } else {
            if (location instanceof PBytecodeRootNode) {
                PBytecodeRootNode bytecodeRootNode = (PBytecodeRootNode)location;
                return bytecodeRootNode.bciToLasti(bci);
            }
            if (location instanceof PBytecodeGeneratorRootNode) {
                PBytecodeGeneratorRootNode generatorRootNode = (PBytecodeGeneratorRootNode)location;
                return generatorRootNode.getBytecodeRootNode().bciToLasti(bci);
            }
        }
        return -1;
    }

    public static final class Reference {
        public static final Reference EMPTY = new Reference(null, null);
        private PFrame pyFrame = null;
        private final RootNode rootNode;
        private boolean escaped = false;
        private final Reference callerInfo;

        public Reference(RootNode rootNode, Reference callerInfo) {
            this.rootNode = rootNode;
            this.callerInfo = callerInfo;
        }

        public RootNode getRootNode() {
            return this.rootNode;
        }

        public void setBackref(Reference backref) {
            assert (this.pyFrame != null) : "setBackref should only be called when the PFrame escaped";
            this.pyFrame.setBackref(backref);
        }

        public void markAsEscaped() {
            this.escaped = true;
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        public PFrame getPyFrame() {
            return this.pyFrame;
        }

        public void setPyFrame(PFrame escapedFrame) {
            assert (this.pyFrame == null || this.pyFrame == escapedFrame) : "cannot change the escaped frame";
            this.pyFrame = escapedFrame;
        }

        public Reference getCallerInfo() {
            return this.callerInfo;
        }
    }
}

