/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.InstantiableStructSequenceBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.tuple.StructSequenceBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Collections;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStatResult, PythonBuiltinClassType.PStatvfsResult, PythonBuiltinClassType.PTerminalSize, PythonBuiltinClassType.PUnameResult, PythonBuiltinClassType.PStructTime, PythonBuiltinClassType.PProfilerEntry, PythonBuiltinClassType.PProfilerSubentry, PythonBuiltinClassType.PStructPasswd, PythonBuiltinClassType.PStructRusage, PythonBuiltinClassType.PFloatInfo, PythonBuiltinClassType.PIntInfo, PythonBuiltinClassType.PHashInfo, PythonBuiltinClassType.PThreadInfo, PythonBuiltinClassType.PUnraisableHookArgs})
public class InstantiableStructSequenceBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = InstantiableStructSequenceBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=2, parameterNames={"$cls", "sequence", "dict"})
    @GenerateNodeFactory
    public static abstract class NewNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static PTuple withDict(VirtualFrame frame, Object cls, Object sequence, Object dict, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached StructSequenceBuiltins.GetSizeNode getSizeNode, @Cached StructSequenceBuiltins.GetFieldNamesNode getFieldNamesNode, @Cached ListNodes.FastConstructListNode fastConstructListNode, @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notASequenceProfile, @Cached InlinedBranchProfile wrongLenProfile, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PyDictGetItem dictGetItem, @Cached InlinedConditionProfile hasDictProfile, @Cached PRaiseNode raiseNode) {
            SequenceStorage seq;
            try {
                seq = fastConstructListNode.execute((Frame)frame, inliningTarget, sequence).getSequenceStorage();
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.TypeError, notASequenceProfile);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CONSTRUCTOR_REQUIRES_A_SEQUENCE);
            }
            boolean hasDict = hasDictProfile.profile(inliningTarget, dict instanceof PDict);
            if (!hasDict && dict != PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_A_DICT_AS_SECOND_ARG_IF_ANY, StructSequence.getTpName(cls));
            }
            int len = seq.length();
            int minLen = getSizeNode.execute(frame, inliningTarget, cls, StructSequence.T_N_SEQUENCE_FIELDS);
            int maxLen = getSizeNode.execute(frame, inliningTarget, cls, StructSequence.T_N_FIELDS);
            int unnamedFields = getSizeNode.execute(frame, inliningTarget, cls, StructSequence.T_N_UNNAMED_FIELDS);
            if (len < minLen || len > maxLen) {
                wrongLenProfile.enter(inliningTarget);
                if (minLen == maxLen) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_A_D_SEQUENCE, StructSequence.getTpName(cls), minLen, len);
                }
                if (len < minLen) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_AN_AT_LEAST_D_SEQUENCE, StructSequence.getTpName(cls), minLen, len);
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.TAKES_AN_AT_MOST_D_SEQUENCE, StructSequence.getTpName(cls), maxLen, len);
            }
            Object[] dst = new Object[maxLen];
            for (int i = 0; i < seq.length(); ++i) {
                dst[i] = getItem.execute(inliningTarget, seq, i);
            }
            TruffleString[] fieldNames = hasDict ? getFieldNamesNode.execute(inliningTarget, cls) : null;
            for (int i = seq.length(); i < dst.length; ++i) {
                Object o;
                dst[i] = hasDict ? ((o = dictGetItem.execute((Frame)frame, inliningTarget, (PDict)dict, fieldNames[i - unnamedFields])) == null ? PNone.NONE : o) : PNone.NONE;
            }
            return PFactory.createTuple(language, cls, getInstanceShape.execute(cls), new ObjectSequenceStorage(dst, minLen));
        }
    }
}

